/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.probdist.PoissonDist;
import umontreal.iro.lecuyer.randvar.PoissonGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.Chrono;

public class Inventory {
    double lambda;
    double c;
    double h;
    double K;
    double k;
    double p;
    RandomVariateGenInt genDemand;
    RandomStream streamDemand = new MRG32k3a();
    RandomStream streamOrder = new MRG32k3a();
    Tally statProfit = new Tally("stats on profit");

    public Inventory(double lambda, double c, double h, double K, double k, double p) {
        this.lambda = lambda;
        this.c = c;
        this.h = h;
        this.K = K;
        this.k = k;
        this.p = p;
        this.genDemand = new PoissonGen(this.streamDemand, new PoissonDist(lambda));
    }

    public double simulateOneRun(int m, int s, int S) {
        int Xj = S;
        double profit = 0.0;
        for (int j = 0; j < m; ++j) {
            int Yj = Xj - this.genDemand.nextInt();
            if (Yj < 0) {
                Yj = 0;
            }
            profit += this.c * (double)(Xj - Yj) - this.h * (double)Yj;
            if (Yj < s && this.streamOrder.nextDouble() < this.p) {
                profit -= this.K + this.k * (double)(S - Yj);
                Xj = S;
                continue;
            }
            Xj = Yj;
        }
        return profit / (double)m;
    }

    public void simulateRuns(int n, int m, int s, int S) {
        for (int i = 0; i < n; ++i) {
            this.statProfit.add(this.simulateOneRun(m, s, S));
        }
    }

    public static void main(String[] args) {
        Chrono timer = new Chrono();
        Inventory system = new Inventory(100.0, 2.0, 0.1, 10.0, 1.0, 0.95);
        system.simulateRuns(500, 2000, 80, 200);
        system.statProfit.setConfidenceIntervalStudent();
        System.out.println(system.statProfit.report(0.9, 3));
        System.out.println("Total CPU time: " + timer.format());
    }
}

