/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.randvar.ErlangConvolutionGen;
import umontreal.iro.lecuyer.randvar.ErlangGen;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.stat.Tally;

public class BankEv {
    static final double minute = 0.016666666666666666;
    int nbTellers;
    int nbBusy;
    int nbWait;
    int nbServed;
    double meanDelay;
    Event nextArriv = new Arrival();
    RandomStream streamArr = new MRG32k3a();
    ErlangGen genServ = new ErlangConvolutionGen((RandomStream)new MRG32k3a(), 2, 60.0);
    RandomStream streamTeller = new MRG32k3a();
    RandomStream streamBalk = new MRG32k3a();
    Tally statServed = new Tally("Nb. served per day");
    Tally avWait = new Tally("Average wait per day (hours)");
    Accumulate wait = new Accumulate("cumulated wait for this day");
    Event e9h45 = new Event(){

        @Override
        public void actions() {
            BankEv.this.meanDelay = 0.03333333333333333;
            BankEv.this.nextArriv.schedule(ExponentialGen.nextDouble(BankEv.this.streamArr, 1.0 / BankEv.this.meanDelay));
        }
    };
    Event e10h = new Event(){

        @Override
        public void actions() {
            double u = BankEv.this.streamTeller.nextDouble();
            BankEv.this.nbTellers = u >= 0.2 ? 3 : (u < 0.05 ? 1 : 2);
            while (BankEv.this.nbWait > 0 && BankEv.this.nbBusy < BankEv.this.nbTellers) {
                ++BankEv.this.nbBusy;
                --BankEv.this.nbWait;
                new Departure().schedule(BankEv.this.genServ.nextDouble());
            }
            BankEv.this.wait.update(BankEv.this.nbWait);
        }
    };
    Event e11h = new Event(){

        @Override
        public void actions() {
            BankEv.this.nextArriv.reschedule((BankEv.this.nextArriv.time() - Sim.time()) / 2.0);
            BankEv.this.meanDelay = 0.016666666666666666;
        }
    };
    Event e14h = new Event(){

        @Override
        public void actions() {
            BankEv.this.nextArriv.reschedule((BankEv.this.nextArriv.time() - Sim.time()) * 2.0);
            BankEv.this.meanDelay = 0.03333333333333333;
        }
    };
    Event e15h = new Event(){

        @Override
        public void actions() {
            BankEv.this.nextArriv.cancel();
        }
    };

    private boolean balk() {
        return this.nbWait > 9 || this.nbWait > 5 && 5.0 * this.streamBalk.nextDouble() < (double)(this.nbWait - 5);
    }

    public void simulOneDay() {
        Sim.init();
        this.wait.init();
        this.nbTellers = 0;
        this.nbBusy = 0;
        this.nbWait = 0;
        this.nbServed = 0;
        this.e9h45.schedule(9.75);
        this.e10h.schedule(10.0);
        this.e11h.schedule(11.0);
        this.e14h.schedule(14.0);
        this.e15h.schedule(15.0);
        Sim.start();
        this.statServed.add(this.nbServed);
        this.wait.update();
        this.avWait.add(this.wait.sum());
    }

    public void simulateDays(int numDays) {
        for (int i = 1; i <= numDays; ++i) {
            this.simulOneDay();
        }
        System.out.println(this.statServed.report());
        System.out.println(this.avWait.report());
    }

    public static void main(String[] args) {
        new BankEv().simulateDays(100);
    }

    class Departure
    extends Event {
        Departure() {
        }

        @Override
        public void actions() {
            ++BankEv.this.nbServed;
            if (BankEv.this.nbWait > 0) {
                new Departure().schedule(BankEv.this.genServ.nextDouble());
                --BankEv.this.nbWait;
                BankEv.this.wait.update(BankEv.this.nbWait);
            } else {
                --BankEv.this.nbBusy;
            }
        }
    }

    class Arrival
    extends Event {
        Arrival() {
        }

        @Override
        public void actions() {
            BankEv.this.nextArriv.schedule(ExponentialGen.nextDouble(BankEv.this.streamArr, 1.0 / BankEv.this.meanDelay));
            if (BankEv.this.nbBusy < BankEv.this.nbTellers) {
                ++BankEv.this.nbBusy;
                new Departure().schedule(BankEv.this.genServ.nextDouble());
            } else if (!BankEv.this.balk()) {
                ++BankEv.this.nbWait;
                BankEv.this.wait.update(BankEv.this.nbWait);
            }
        }
    }
}

