/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Indonesia
extends Calendar {
    public Indonesia() {
        this(Market.BEJ);
    }

    public Indonesia(Market market) {
        switch (market) {
            case BEJ: 
            case JSX: {
                this.impl = new BejImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class BejImpl
    extends Calendar.WesternImpl {
        private BejImpl() {
        }

        @Override
        public String name() {
            return "Jakarta stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            int dd = date.dayOfYear();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || d == 1 && m == Month.January || dd == em - 3 || dd == em + 38 || d == 17 && m == Month.August || d == 25 && m == Month.December) {
                return false;
            }
            if (y == 2005 && (d == 21 && m == Month.January || d == 9 && m == Month.February || d == 10 && m == Month.February || d == 11 && m == Month.March || d == 22 && m == Month.April || d == 24 && m == Month.May || d == 2 && m == Month.September || (d == 3 || d == 4) && m == Month.November || (d == 2 || d == 7 || d == 8) && m == Month.November || d == 26 && m == Month.December)) {
                return false;
            }
            if (y == 2006 && (d == 10 && m == Month.January || d == 31 && m == Month.January || d == 30 && m == Month.March || d == 10 && m == Month.April || d == 21 && m == Month.August || (d == 24 || d == 25) && m == Month.October || (d == 23 || d == 26 || d == 27) && m == Month.October)) {
                return false;
            }
            if (y == 2007 && (d == 19 && m == Month.March || d == 1 && m == Month.June || d == 20 && m == Month.December || d == 18 && m == Month.May || (d == 12 || d == 15 || d == 16) && m == Month.October || (d == 21 || d == 24) && m == Month.October)) {
                return false;
            }
            if (y == 2007 && ((d == 10 || d == 11) && m == Month.January || (d == 7 || d == 8) && m == Month.February || d == 7 && m == Month.March || d == 20 && m == Month.March || d == 20 && m == Month.May || d == 30 && m == Month.July || d == 30 && m == Month.September || (d == 1 || d == 2 || d == 3) && m == Month.October || d == 8 && m == Month.December || d == 29 && m == Month.December || d == 31 && m == Month.December || d == 18 && m == Month.August)) {
                return false;
            }
            if (y == 2008 && (d == 10 && m == Month.January || d == 11 && m == Month.January || d == 7 && m == Month.February || d == 8 && m == Month.February || d == 7 && m == Month.March || d == 20 && m == Month.March || d == 20 && m == Month.May || d == 30 && m == Month.July || d == 18 && m == Month.August || d == 30 && m == Month.September || d == 1 && m == Month.October || d == 2 && m == Month.October || d == 3 && m == Month.October || d == 8 && m == Month.December || d == 29 && m == Month.December || d == 31 && m == Month.December)) {
                return false;
            }
            return y != 2009 || !(d == 2 && m == Month.January || d == 26 && m == Month.January || d == 26 && m == Month.March || d == 9 && m == Month.March || d == 20 && m == Month.July || d == 18 && m == Month.September || d == 23 && m == Month.September || d == 21 && m == Month.September || d == 22 && m == Month.September || d == 27 && m == Month.November || d == 18 && m == Month.December || d == 24 && m == Month.December) && (d != 31 || m != Month.December);
        }
    }

    public static enum Market {
        BEJ,
        JSX;

    }
}

