/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

public class IMM {
    public static boolean isIMMdate(Date date) {
        return IMM.isIMMdate(date, true);
    }

    public static boolean isIMMdate(Date date, boolean mainCycle) {
        if (date.weekday() != Weekday.Wednesday) {
            return false;
        }
        int d = date.dayOfMonth();
        if (d < 15 || d > 21) {
            return false;
        }
        if (!mainCycle) {
            return true;
        }
        Month m = date.month();
        return m == Month.March || m == Month.June || m == Month.September || m == Month.December;
    }

    public static boolean isIMMcode(String in) {
        return IMM.isIMMcode(in, true);
    }

    public static boolean isIMMcode(String in, boolean mainCycle) {
        if (in.length() != 2) {
            return false;
        }
        if ("0123456789".indexOf(in.charAt(1)) == -1) {
            return false;
        }
        String str1 = mainCycle ? "hmzuHMZU" : "fghjkmnquvxzFGHJKMNQUVXZ";
        return str1.indexOf(in.charAt(0)) != -1;
    }

    public static Date date(String immCode) {
        return IMM.date(immCode, new Date());
    }

    public static Date date(String immCode, Date refDate) {
        QL.require(IMM.isIMMcode(immCode, false), "not a valid IMM code");
        Date referenceDate = refDate.isNull() ? new Settings().evaluationDate() : refDate;
        char code = immCode.charAt(0);
        Month m = Month.valueOf(code);
        int y = immCode.charAt(1) - 48;
        if (y == 0 && referenceDate.year() <= 1909) {
            y += 10;
        }
        int yMod = referenceDate.year() % 10;
        Date result = IMM.nextDate(new Date(1, m, y += referenceDate.year() - yMod), false);
        if (result.lt(referenceDate)) {
            return IMM.nextDate(new Date(1, m, y + 10), false);
        }
        return result;
    }

    public static Date nextDate() {
        return IMM.nextDate(new Date(), true);
    }

    public static Date nextDate(Date date) {
        return IMM.nextDate(date, true);
    }

    public static Date nextDate(Date date, boolean mainCycle) {
        Date result;
        int m;
        Date refDate = date.isNull() ? new Settings().evaluationDate() : date;
        int y = refDate.year();
        int offset = mainCycle ? 3 : 1;
        int skipMonths = offset - (m = refDate.month().value()) % offset;
        if (skipMonths != offset || refDate.dayOfMonth() > 21) {
            if ((skipMonths += m) <= 12) {
                m = skipMonths;
            } else {
                m = skipMonths - 12;
                ++y;
            }
        }
        if ((result = Date.nthWeekday(3, Weekday.Wednesday, Month.valueOf(m), y)).le(refDate)) {
            result = IMM.nextDate(new Date(22, Month.valueOf(m), y), mainCycle);
        }
        return result;
    }

    public static Date nextDate(String immCode) {
        return IMM.nextDate(immCode, true, new Date());
    }

    public static Date nextDate(String immCode, boolean mainCycle) {
        return IMM.nextDate(immCode, mainCycle, new Date());
    }

    public static Date nextDate(String IMMcode, boolean mainCycle, Date referenceDate) {
        Date immDate = IMM.date(IMMcode, referenceDate);
        return IMM.nextDate(immDate.inc(), mainCycle);
    }

    public static String nextCode() {
        return IMM.nextCode(new Date());
    }

    public static String nextCode(Date d) {
        return IMM.nextCode(d, true);
    }

    public static String nextCode(Date d, boolean mainCycle) {
        Date date = IMM.nextDate(d, mainCycle);
        return IMM.code(date);
    }

    public static String nextCode(String immCode) {
        return IMM.nextCode(immCode, true);
    }

    public static String nextCode(String immCode, boolean mainCycle) {
        return IMM.nextCode(immCode, mainCycle, new Date());
    }

    public static String nextCode(String immCode, boolean mainCycle, Date referenceDate) {
        Date date = IMM.nextDate(immCode, mainCycle, referenceDate);
        return IMM.code(date);
    }

    public static String code(Date date) {
        QL.require(IMM.isIMMdate(date, false), "not an IMM date");
        int y = date.year() % 10;
        char code = date.month().getImmChar();
        StringBuilder sb = new StringBuilder();
        sb.append(code).append(y);
        String imm = sb.toString();
        QL.ensure(IMM.isIMMcode(imm, false), "the result is an invalid IMM code");
        return imm;
    }
}

