/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.util;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.calendars.NullCalendar;

public class Utilities {
    public static double norm(Array arr, double h) {
        Array f2 = new Array(arr.size());
        for (int i = 0; i < arr.size(); ++i) {
            double d = arr.get(i);
            f2.set(i, d * d);
        }
        double I = 0.0;
        for (int i = 0; i < f2.size(); ++i) {
            I += f2.get(i);
        }
        I -= 0.5 * f2.first();
        I -= 0.5 * f2.last();
        return Math.sqrt(I *= h);
    }

    public static double relativeError(double x1, double x2, double reference) {
        if (reference != 0.0) {
            return Math.abs(x1 - x2) / reference;
        }
        return Math.abs(x1 - x2);
    }

    public static YieldTermStructure flatRate(Date today, Quote forward, DayCounter dc) {
        return new FlatForward(today, new Handle<Quote>(forward), dc);
    }

    public static YieldTermStructure flatRate(Date today, double forward, DayCounter dc) {
        return Utilities.flatRate(today, new SimpleQuote(forward), dc);
    }

    public static YieldTermStructure flatRate(Quote forward, DayCounter dc) {
        return new FlatForward(0, (Calendar)new NullCalendar(), new Handle<Quote>(forward), dc);
    }

    public static YieldTermStructure flatRate(double forward, DayCounter dc) {
        return Utilities.flatRate(new SimpleQuote(forward), dc);
    }

    public static BlackVolTermStructure flatVol(Date today, Quote vol, DayCounter dc) {
        return new BlackConstantVol(today, (Calendar)new NullCalendar(), new Handle<Quote>(vol), dc);
    }

    public static BlackVolTermStructure flatVol(Date today, double vol, DayCounter dc) {
        return Utilities.flatVol(today, new SimpleQuote(vol), dc);
    }

    public static BlackVolTermStructure flatVol(Quote vol, DayCounter dc) {
        return new BlackConstantVol(0, (Calendar)new NullCalendar(), new Handle<Quote>(vol), dc);
    }

    public static BlackVolTermStructure flatVol(double vol, DayCounter dc) {
        return Utilities.flatVol(new SimpleQuote(vol), dc);
    }
}

