/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.model.volatility;

import org.jquantlib.QL;
import org.jquantlib.model.volatility.ConstantEstimator;
import org.jquantlib.model.volatility.SimpleLocalEstimator;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.TimeSeries;
import org.junit.Assert;
import org.junit.Test;

public class EstimatorsTest {
    private final TimeSeries<Double> ts;

    public EstimatorsTest() {
        QL.info("Testing volatility model construction...");
        Date[] dates = new Date[]{new Date(25, Month.March, 2005), new Date(29, Month.March, 2005), new Date(15, Month.March, 2005), new Date(21, Month.March, 2005), new Date(27, Month.March, 2005)};
        double[] values = new double[]{1.2, 2.3, 0.3, 2.0, 2.5};
        this.ts = new TimeSeries<Double>(Double.class);
        for (int i = 0; i < dates.length; ++i) {
            this.ts.put(dates[i], values[i]);
        }
    }

    @Test
    public void testSECalculate() {
        SimpleLocalEstimator sle = new SimpleLocalEstimator(0.002777777777777778);
        TimeSeries<Double> locale = sle.calculate(this.ts);
        Assert.assertNotNull(locale);
    }

    @Test
    public void testCECalculate() {
        SimpleLocalEstimator sle = new SimpleLocalEstimator(0.002777777777777778);
        TimeSeries<Double> locale = sle.calculate(this.ts);
        ConstantEstimator ce = new ConstantEstimator(1);
        TimeSeries<Double> value = ce.calculate(locale);
        Assert.assertNotNull(value);
    }
}

