/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.SimpsonIntegral;
import org.jquantlib.math.interpolations.BackwardFlatInterpolation;
import org.jquantlib.math.interpolations.CubicInterpolation;
import org.jquantlib.math.interpolations.ForwardFlatInterpolation;
import org.jquantlib.math.interpolations.LinearInterpolation;
import org.jquantlib.math.interpolations.SABRInterpolation;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.LevenbergMarquardt;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.Simplex;
import org.jquantlib.math.randomnumbers.SobolRsg;
import org.jquantlib.termstructures.volatilities.Sabr;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class InterpolationTest {
    public InterpolationTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testAsFunctor() {
        final class NotThrown
        extends RuntimeException {
            NotThrown() {
            }
        }
        QL.info("Testing use of interpolations as functors...");
        Array x = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
        Array y = new Array(new double[]{5.0, 4.0, 3.0, 2.0, 1.0});
        LinearInterpolation f = new LinearInterpolation(x, y);
        f.update();
        Array x2 = new Array(new double[]{-2.0, -1.0, 0.0, 1.0, 3.0, 4.0, 5.0, 6.0, 7.0});
        int N = x2.size();
        double tolerance = 1.0E-12;
        try {
            Array y2 = x2.clone().transform(f);
            System.out.println(y2);
            throw new NotThrown();
        }
        catch (NotThrown ex) {
            throw new LibraryException("failed to throw exception when trying to extrapolate");
        }
        catch (Exception ex) {
            System.out.println(ex);
            f.enableExtrapolation();
            Array y2 = x2.clone().transform(f);
            System.out.println(y2);
            for (int i = 0; i < N - 1; ++i) {
                double expected = 5.0 - x2.get(i);
                double calculated = y2.get(i);
                Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + calculated + "\n    error:              " + Math.abs(calculated - expected)), (Math.abs(calculated - expected) > 1.0E-12 ? 1 : 0) != 0);
            }
            return;
        }
    }

    @Test
    public void testBackwardFlat() {
        int i;
        double expected;
        double calculated;
        double p;
        int i2;
        QL.info("Testing backward-flat interpolation...");
        Array x = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
        Array y = new Array(new double[]{5.0, 4.0, 3.0, 2.0, 1.0});
        BackwardFlatInterpolation f = new BackwardFlatInterpolation(x, y);
        f.update();
        int N = x.size();
        double tolerance = 1.0E-12;
        for (i2 = 0; i2 < N; ++i2) {
            p = x.get(i2);
            calculated = f.op(p);
            expected = y.get(i2);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + calculated + "\n    error:              " + Math.abs(calculated - expected)), (Math.abs(calculated - expected) > 1.0E-12 ? 1 : 0) != 0);
        }
        for (i2 = 0; i2 < N - 1; ++i2) {
            p = (x.get(i2) + x.get(i2 + 1)) / 2.0;
            calculated = f.op(p);
            expected = y.get(i2 + 1);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + calculated + "\n    error:              " + Math.abs(calculated - expected)), (Math.abs(calculated - expected) > 1.0E-12 ? 1 : 0) != 0);
        }
        f.enableExtrapolation();
        double p2 = x.get(0) - 0.5;
        double calculated2 = f.op(p2);
        double expected2 = y.get(0);
        Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected2 + "\n    calculated value: " + calculated2 + "\n    error:              " + Math.abs(calculated2 - expected2)), (Math.abs(calculated2 - expected2) > 1.0E-12 ? 1 : 0) != 0);
        p2 = x.get(N - 1) + 0.5;
        calculated2 = f.op(p2);
        expected2 = y.get(N - 1);
        Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected2 + "\n    calculated value: " + calculated2 + "\n    error:              " + Math.abs(calculated2 - expected2)), (Math.abs(calculated2 - expected2) > 1.0E-12 ? 1 : 0) != 0);
        calculated2 = f.primitive(x.get(0));
        expected2 = 0.0;
        Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected2 + "\n    calculated value: " + calculated2 + "\n    error:              " + Math.abs(calculated2 - expected2)), (Math.abs(calculated2 - expected2) > 1.0E-12 ? 1 : 0) != 0);
        double sum = 0.0;
        for (i = 1; i < N - 1; ++i) {
            calculated = f.primitive(x.get(i));
            expected = sum += (x.get(i) - x.get(i - 1)) * y.get(i);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + calculated + "\n    error:              " + Math.abs(calculated - expected)), (Math.abs(calculated - expected) > 1.0E-12 ? 1 : 0) != 0);
        }
        sum = 0.0;
        for (i = 0; i < N - 1; ++i) {
            double p3 = (x.get(i) + x.get(i + 1)) / 2.0;
            double calculated3 = f.primitive(p3);
            double expected3 = sum += (x.get(i + 1) - x.get(i)) * y.get(i + 1) / 2.0;
            sum += (x.get(i + 1) - x.get(i)) * y.get(i + 1) / 2.0;
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected3 + "\n    calculated value: " + calculated3 + "\n    error:              " + Math.abs(calculated3 - expected3)), (Math.abs(calculated3 - expected3) > 1.0E-12 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSplineOnGenericValues() {
        QL.info("Testing spline interpolation on generic values...");
        Array generic_x = new Array(new double[]{0.0, 1.0, 3.0, 4.0});
        Array generic_y = new Array(new double[]{0.0, 0.0, 2.0, 2.0});
        Array generic_natural_y2 = new Array(new double[]{0.0, 1.5, -1.5, 0.0});
        int n = generic_x.size();
        double[] x35 = new double[3];
        CubicInterpolation f = new CubicInterpolation(generic_x, generic_y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.SecondDerivative, generic_natural_y2.first(), CubicInterpolation.BoundaryCondition.SecondDerivative, generic_natural_y2.last());
        f.update();
        this.checkValues("Natural spline", f, generic_x, generic_y);
        for (int i = 0; i < n; ++i) {
            double interpolated = f.secondDerivative(generic_x.get(i));
            double error = interpolated - generic_natural_y2.get(i);
            Assert.assertFalse((String)("Natural spline interpolation second derivative failed at x=" + generic_x.get(i) + "\n interpolated value: " + interpolated + "\n expected value:     " + generic_natural_y2.get(i) + "\n error:              " + error), (Math.abs(error) > 3.0E-16 ? 1 : 0) != 0);
        }
        x35[1] = f.op(3.5);
        double y1a = 0.0;
        double y1b = 0.0;
        f = new CubicInterpolation(generic_x, generic_y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.FirstDerivative, 0.0, CubicInterpolation.BoundaryCondition.FirstDerivative, 0.0);
        f.update();
        this.checkValues("Clamped spline", f, generic_x, generic_y);
        this.check1stDerivativeValue("Clamped spline", f, generic_x.first(), 0.0);
        this.check1stDerivativeValue("Clamped spline", f, generic_x.last(), 0.0);
        x35[0] = f.op(3.5);
        f = new CubicInterpolation(generic_x, generic_y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
        f.update();
        this.checkValues("Not-a-knot spline", f, generic_x, generic_y);
        this.checkNotAKnotCondition("Not-a-knot spline", f);
        x35[2] = f.op(3.5);
        Assert.assertFalse((String)("Spline interpolation failure\n at x = 3.5\n clamped spline    " + x35[0] + "\n natural spline    " + x35[1] + "\n not-a-knot spline " + x35[2] + "\n values should be in increasing order"), (x35[0] > x35[1] || x35[1] > x35[2] ? 1 : 0) != 0);
    }

    @Test
    public void testSimmetricEndConditions() {
        QL.info("Testing symmetry of spline interpolation end-conditions...");
        int n = 9;
        Array x = this.xRange(-1.8, 1.8, 9);
        Array y = this.gaussian(x);
        CubicInterpolation f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
        f.update();
        this.checkValues("Not-a-knot spline", f, x, y);
        this.checkNotAKnotCondition("Not-a-knot spline", f);
        this.checkSymmetry("Not-a-knot spline", f, x.first());
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
        f.update();
        this.checkValues("MC not-a-knot spline", f, x, y);
        this.checkSymmetry("MC not-a-knot spline", f, x.first());
    }

    @Test
    public void testForwardFlat() {
        int i;
        double expected;
        double calculated;
        double p;
        int i2;
        QL.info("Testing forward-flat interpolation...");
        Array x = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
        Array y = new Array(new double[]{5.0, 4.0, 3.0, 2.0, 1.0});
        ForwardFlatInterpolation f = new ForwardFlatInterpolation(x, y);
        f.update();
        int N = x.size();
        double tolerance = 1.0E-12;
        for (i2 = 0; i2 < N; ++i2) {
            p = x.get(i2);
            calculated = f.op(p);
            expected = y.get(i2);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + calculated + "\n    error:              " + Math.abs(calculated - expected)), (Math.abs(calculated - expected) > 1.0E-12 ? 1 : 0) != 0);
        }
        for (i2 = 0; i2 < N - 1; ++i2) {
            p = (x.get(i2) + x.get(i2 + 1)) / 2.0;
            calculated = f.op(p);
            expected = y.get(i2);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + calculated + "\n    error:              " + Math.abs(calculated - expected)), (Math.abs(calculated - expected) > 1.0E-12 ? 1 : 0) != 0);
        }
        f.enableExtrapolation();
        double p2 = x.get(0) - 0.5;
        double calculated2 = f.op(p2);
        double expected2 = y.get(0);
        Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected2 + "\n    calculated value: " + calculated2 + "\n    error:              " + Math.abs(calculated2 - expected2)), (Math.abs(calculated2 - expected2) > 1.0E-12 ? 1 : 0) != 0);
        p2 = x.get(N - 1) + 0.5;
        calculated2 = f.op(p2);
        expected2 = y.get(N - 1);
        Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected2 + "\n    calculated value: " + calculated2 + "\n    error:              " + Math.abs(calculated2 - expected2)), (Math.abs(calculated2 - expected2) > 1.0E-12 ? 1 : 0) != 0);
        calculated2 = f.primitive(x.get(0));
        expected2 = 0.0;
        Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected2 + "\n    calculated value: " + calculated2 + "\n    error:              " + Math.abs(calculated2 - expected2)), (Math.abs(calculated2 - expected2) > 1.0E-12 ? 1 : 0) != 0);
        double sum = 0.0;
        for (i = 1; i < N; ++i) {
            calculated = f.primitive(x.get(i));
            expected = sum += (x.get(i) - x.get(i - 1)) * y.get(i - 1);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + calculated + "\n    error:              " + Math.abs(calculated - expected)), (Math.abs(calculated - expected) > 1.0E-12 ? 1 : 0) != 0);
        }
        sum = 0.0;
        for (i = 0; i < N - 1; ++i) {
            double p3 = (x.get(i) + x.get(i + 1)) / 2.0;
            double calculated3 = f.primitive(p3);
            double expected3 = sum += (x.get(i + 1) - x.get(i)) * y.get(i) / 2.0;
            sum += (x.get(i + 1) - x.get(i)) * y.get(i) / 2.0;
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected3 + "\n    calculated value: " + calculated3 + "\n    error:              " + Math.abs(calculated3 - expected3)), (Math.abs(calculated3 - expected3) > 1.0E-12 ? 1 : 0) != 0);
        }
    }

    @Ignore
    @Test
    public void testMultiSpline() {
        QL.info("Testing N-dimensional cubic spline...");
        int[] dim = new int[]{6, 5, 5, 6, 4};
        double[] offsets = new double[]{1.005, 14.0, 33.005, 35.025, 19.025};
        double[] args = new double[]{offsets[0], offsets[1], offsets[2], offsets[3], offsets[4]};
        double s = args[0];
        double t = args[1];
        double u = args[2];
        double v = args[3];
        double w = args[4];
        Array[] grid = new Array[5];
        double r = 0.15;
        for (int i = 0; i < 5; ++i) {
            grid[i] = new Array(0);
        }
        r = 0.01;
        double[][][][][] y5 = new double[dim[0]][dim[1]][dim[2]][dim[3]][dim[4]];
        for (int i = 0; i < dim[0]; ++i) {
            for (int j = 0; j < dim[1]; ++j) {
                for (int k = 0; k < dim[2]; ++k) {
                    for (int l = 0; l < dim[3]; ++l) {
                        for (int m = 0; m < dim[4]; ++m) {
                            y5[i][j][k][l][m] = this.multif(grid[0].get(i), grid[1].get(j), grid[2].get(k), grid[3].get(l), grid[4].get(m));
                        }
                    }
                }
            }
        }
        class MultiCubicSpline {
            MultiCubicSpline() {
            }

            public double op(double[] args) {
                throw new UnsupportedOperationException();
            }
        }
        MultiCubicSpline cs = new MultiCubicSpline();
        for (int i = 1; i < dim[0] - 1; ++i) {
            for (int j = 1; j < dim[1] - 1; ++j) {
                for (int k = 1; k < dim[2] - 1; ++k) {
                    for (int l = 1; l < dim[3] - 1; ++l) {
                        for (int m = 1; m < dim[4] - 1; ++m) {
                            s = grid[0].get(i);
                            t = grid[1].get(j);
                            u = grid[2].get(k);
                            v = grid[3].get(l);
                            w = grid[4].get(m);
                            double interpolated = cs.op(args);
                            double expected = y5[i][j][k][l][m];
                            double error = Math.abs(interpolated - expected);
                            double tolerance = 1.0E-16;
                            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + interpolated + "\n    error:              " + error), (error > 1.0E-16 ? 1 : 0) != 0);
                        }
                    }
                }
            }
        }
        long seed = 42L;
        SobolRsg rsg = new SobolRsg(5, 42L);
        double tolerance = 1.7E-4;
        for (int i = 0; i < 1023; ++i) {
            double[] next = rsg.nextSequence().value();
            s = grid[0].first() + next[0] * (grid[0].last() - grid[0].first());
            t = grid[1].first() + next[1] * (grid[1].last() - grid[1].first());
            u = grid[2].first() + next[2] * (grid[2].last() - grid[2].first());
            v = grid[3].first() + next[3] * (grid[3].last() - grid[3].first());
            w = grid[4].first() + next[4] * (grid[4].last() - grid[4].first());
            double interpolated = cs.op(args);
            double expected = this.multif(s, t, u, v, w);
            double error = Math.abs(interpolated - expected);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + expected + "\n    calculated value: " + interpolated + "\n    error:              " + error), (error > 1.7E-4 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivativeEndConditions() {
        QL.info("Testing derivative end-conditions for spline interpolation...");
        int n = 4;
        Array x = this.xRange(-2.0, 2.0, 4);
        Array y = this.parabolic(x);
        CubicInterpolation f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
        f.update();
        this.checkValues("Not-a-knot spline", f, x, y);
        this.check1stDerivativeValue("Not-a-knot spline", f, x.get(0), 4.0);
        this.check1stDerivativeValue("Not-a-knot spline", f, x.get(3), -4.0);
        this.check2ndDerivativeValue("Not-a-knot spline", f, x.get(0), -2.0);
        this.check2ndDerivativeValue("Not-a-knot spline", f, x.get(3), -2.0);
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.FirstDerivative, 4.0, CubicInterpolation.BoundaryCondition.FirstDerivative, -4.0);
        f.update();
        this.checkValues("Clamped spline", f, x, y);
        this.check1stDerivativeValue("Clamped spline", f, x.get(0), 4.0);
        this.check1stDerivativeValue("Clamped spline", f, x.get(3), -4.0);
        this.check2ndDerivativeValue("Clamped spline", f, x.get(0), -2.0);
        this.check2ndDerivativeValue("Clamped spline", f, x.get(3), -2.0);
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.SecondDerivative, -2.0, CubicInterpolation.BoundaryCondition.SecondDerivative, -2.0);
        f.update();
        this.checkValues("SecondDerivative spline", f, x, y);
        this.check1stDerivativeValue("SecondDerivative spline", f, x.get(0), 4.0);
        this.check1stDerivativeValue("SecondDerivative spline", f, x.get(3), -4.0);
        this.check2ndDerivativeValue("SecondDerivative spline", f, x.get(0), -2.0);
        this.check2ndDerivativeValue("SecondDerivative spline", f, x.get(3), -2.0);
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
        f.update();
        this.checkValues("MC Not-a-knot spline", f, x, y);
        this.check1stDerivativeValue("MC Not-a-knot spline", f, x.get(0), 4.0);
        this.check1stDerivativeValue("MC Not-a-knot spline", f, x.get(3), -4.0);
        this.check2ndDerivativeValue("MC Not-a-knot spline", f, x.get(0), -2.0);
        this.check2ndDerivativeValue("MC Not-a-knot spline", f, x.get(3), -2.0);
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.FirstDerivative, 4.0, CubicInterpolation.BoundaryCondition.FirstDerivative, -4.0);
        f.update();
        this.checkValues("MC Clamped spline", f, x, y);
        this.check1stDerivativeValue("MC Clamped spline", f, x.get(0), 4.0);
        this.check1stDerivativeValue("MC Clamped spline", f, x.get(3), -4.0);
        this.check2ndDerivativeValue("MC Clamped spline", f, x.get(0), -2.0);
        this.check2ndDerivativeValue("MC Clamped spline", f, x.get(3), -2.0);
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, -2.0, CubicInterpolation.BoundaryCondition.SecondDerivative, -2.0);
        f.update();
        this.checkValues("MC SecondDerivative spline", f, x, y);
        this.check1stDerivativeValue("MC SecondDerivative spline", f, x.get(0), 4.0);
        this.check1stDerivativeValue("MC SecondDerivative spline", f, x.get(3), -4.0);
        this.check2ndDerivativeValue("SecondDerivative spline", f, x.get(0), -2.0);
        this.check2ndDerivativeValue("MC SecondDerivative spline", f, x.get(3), -2.0);
    }

    @Test
    public void testSplineErrorOnGaussianValues() {
        QL.info("Testing spline approximation on Gaussian data sets...");
        int[] points = new int[]{5, 9, 17, 33};
        double[] tabulatedErrors = new double[]{0.035, 0.002, 4.0E-5, 1.8E-6};
        double[] toleranceOnTabErr = new double[]{0.001, 1.0E-4, 1.0E-6, 1.0E-7};
        double[] tabulatedMCErrors = new double[]{0.017, 0.002, 4.0E-5, 1.8E-6};
        double[] toleranceOnTabMCErr = new double[]{0.001, 1.0E-4, 1.0E-6, 1.0E-7};
        SimpsonIntegral integral = new SimpsonIntegral(1.0E-12, 10000);
        double scaleFactor = 1.9;
        for (int i = 0; i < points.length; ++i) {
            int n = points[i];
            Array x = this.xRange(-1.7, 1.9, n);
            Array y = this.gaussian(x);
            CubicInterpolation f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
            f.update();
            double result = Math.sqrt(integral.op(this.makeErrorFunction(f), -1.7, 1.9));
            Assert.assertFalse((String)("Not-a-knot spline interpolation \n    sample points:      " + n + "\n    norm of difference: " + (result /= 1.9) + "\n    it should be:       " + tabulatedErrors[i]), (Math.abs(result - tabulatedErrors[i]) > toleranceOnTabErr[i] ? 1 : 0) != 0);
            f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
            f.update();
            result = Math.sqrt(integral.op(this.makeErrorFunction(f), -1.7, 1.9));
            Assert.assertFalse((String)("MC Not-a-knot spline interpolation \n    sample points:      \n    norm of difference: " + (result /= 1.9) + "\n    it should be:       " + tabulatedErrors[i]), (Math.abs(result - tabulatedMCErrors[i]) > toleranceOnTabMCErr[i] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSplineOnRPN15AValues() {
        QL.info("Testing Clamped spline interpolation on RPN15A data set...");
        Array RPN15A_x = new Array(new double[]{7.99, 8.09, 8.19, 8.7, 9.2, 10.0, 12.0, 15.0, 20.0});
        Array RPN15A_y = new Array(new double[]{0.0, 2.76429E-5, 4.37498E-5, 0.169183, 0.469428, 0.94374, 0.998636, 0.999919, 0.999994});
        CubicInterpolation f = new CubicInterpolation(RPN15A_x, RPN15A_y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0);
        f.update();
        this.checkValues("Natural spline", f, RPN15A_x, RPN15A_y);
        this.check2ndDerivativeValue("Natural spline", f, RPN15A_x.first(), 0.0);
        this.check2ndDerivativeValue("Natural spline", f, RPN15A_x.last(), 0.0);
        double x_bad = 11.0;
        double interpolated = f.op(11.0);
        Assert.assertFalse((String)("Natural spline interpolation poor performance unverified\n    at x = 11.0\n    interpolated value: " + interpolated + "\n    expected value > 1.0"), (interpolated < 1.0 ? 1 : 0) != 0);
        f = new CubicInterpolation(RPN15A_x, RPN15A_y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.FirstDerivative, 0.0, CubicInterpolation.BoundaryCondition.FirstDerivative, 0.0);
        f.update();
        this.checkValues("Clamped spline", f, RPN15A_x, RPN15A_y);
        this.check1stDerivativeValue("Clamped spline", f, RPN15A_x.first(), 0.0);
        this.check1stDerivativeValue("Clamped spline", f, RPN15A_x.last(), 0.0);
        interpolated = f.op(11.0);
        Assert.assertFalse((String)("Clamped spline interpolation poor performance unverified\n    at x = 11.0\n    interpolated value: " + interpolated + "\n    expected value > 1.0"), (interpolated < 1.0 ? 1 : 0) != 0);
        f = new CubicInterpolation(RPN15A_x, RPN15A_y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
        f.update();
        this.checkValues("Not-a-knot spline", f, RPN15A_x, RPN15A_y);
        this.checkNotAKnotCondition("Not-a-knot spline", f);
        interpolated = f.op(11.0);
        Assert.assertFalse((String)("Not-a-knot spline interpolation poor performance unverified\n    at x = 11.0\n    interpolated value: " + interpolated + "\n    expected value > 1.0"), (interpolated < 1.0 ? 1 : 0) != 0);
        f = new CubicInterpolation(RPN15A_x, RPN15A_y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0, CubicInterpolation.BoundaryCondition.SecondDerivative, 0.0);
        f.update();
        this.checkValues("MC natural spline", f, RPN15A_x, RPN15A_y);
        interpolated = f.op(11.0);
        Assert.assertFalse((String)("MC natural spline interpolation good performance unverified\n    at x = 11.0\n    interpolated value: " + interpolated + "\n    expected value > 1.0"), (interpolated > 1.0 ? 1 : 0) != 0);
        f = new CubicInterpolation(RPN15A_x, RPN15A_y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.FirstDerivative, 0.0, CubicInterpolation.BoundaryCondition.FirstDerivative, 0.0);
        f.update();
        this.checkValues("MC clamped spline", f, RPN15A_x, RPN15A_y);
        this.check1stDerivativeValue("MC clamped spline", f, RPN15A_x.first(), 0.0);
        this.check1stDerivativeValue("MC clamped spline", f, RPN15A_x.last(), 0.0);
        interpolated = f.op(11.0);
        Assert.assertFalse((String)("MC clamped spline interpolation good performance unverified\n    at x = 11.0\n    interpolated value: " + interpolated + "\n    expected value > 1.0"), (interpolated > 1.0 ? 1 : 0) != 0);
        f = new CubicInterpolation(RPN15A_x, RPN15A_y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE, CubicInterpolation.BoundaryCondition.NotAKnot, Double.MAX_VALUE);
        f.update();
        this.checkValues("MC not-a-knot spline", f, RPN15A_x, RPN15A_y);
        interpolated = f.op(11.0);
        Assert.assertFalse((String)("MC clamped spline interpolation good performance unverified\n    at x = 11.0\n    interpolated value: " + interpolated + "\n    expected value > 1.0"), (interpolated > 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSplineOnGaussianValues() {
        double interpolated2;
        double interpolated;
        Array y;
        Array x;
        double j;
        QL.info("Testing spline interpolation on a Gaussian data set...");
        int n = 5;
        double x1_bad = -1.7;
        double x2_bad = 1.7;
        double start = -1.9;
        for (j = 0.0; j < 2.0; j += 1.0) {
            x = this.xRange(start, start + 3.6, 5);
            y = this.gaussian(x);
            CubicInterpolation f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, false, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0);
            this.checkValues("Not-a-knot spline", f, x, y);
            this.checkNotAKnotCondition("Not-a-knot spline", f);
            interpolated = f.op(-1.7);
            interpolated2 = f.op(1.7);
            Assert.assertFalse((String)("Not-a-knot spline interpolation bad performance unverified\n    at x = -1.7\n    interpolated value: " + interpolated + "\n    at x = " + 1.7 + "\n    interpolated value: " + interpolated2 + "\n    at least one of them was expected to be < 0.0"), (interpolated > 0.0 && interpolated2 > 0.0 ? 1 : 0) != 0);
            f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0);
            f.update();
            this.checkValues("MC not-a-knot spline", f, x, y);
            interpolated = f.op(-1.7);
            interpolated2 = f.op(1.7);
            Assert.assertFalse((String)("Not-a-knot spline interpolation bad performance unverified\nat x = -1.7 interpolated value: " + interpolated + "\nat x = " + 1.7 + " interpolated value: " + interpolated + "\n at least one of them was expected to be < 0.0"), (interpolated <= 0.0 || interpolated2 <= 0.0 ? 1 : 0) != 0);
            start += 0.2;
        }
        QL.info("Testing spline interpolation on a Gaussian data set...");
        start = -1.9;
        for (j = 0.0; j < 2.0; j += 1.0) {
            x = this.xRange(start, start + 3.6, 5);
            y = this.gaussian(x);
            CubicInterpolation interpolation = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0);
            interpolation.update();
            this.checkValues("MC not-a-knot spline", interpolation, x, y);
            interpolated = interpolation.op(-1.7);
            interpolated2 = interpolation.op(1.7);
            if (interpolated > 0.0 && interpolated2 > 0.0) {
                Assert.assertFalse((String)("Not-a-knot spline interpolation bad performance unverified\nat x = -1.7 interpolated value: " + interpolated + "\nat x = " + 1.7 + " interpolated value: " + interpolated + "\n at least one of them was expected to be < 0.0"), (interpolated <= 0.0 || interpolated2 <= 0.0 ? 1 : 0) != 0);
            }
            start += 0.2;
        }
    }

    @Test
    public void testNonRestrictiveHymanFilter() {
        int n = 4;
        Array x = this.xRange(-2.0, 2.0, 4);
        Array y = this.parabolic(x);
        double zero = 0.0;
        double expected = 0.0;
        CubicInterpolation f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0, CubicInterpolation.BoundaryCondition.NotAKnot, 0.0);
        double interpolated = f.op(0.0);
        Assert.assertFalse((String)("MC not-a-knot spline interpolation failed at x = 0.0\n    interpolated value: " + interpolated + "\n    expected value:     " + 0.0 + "\n    error:              " + Math.abs(interpolated - 0.0)), (Math.abs(interpolated - 0.0) > 1.0E-15 ? 1 : 0) != 0);
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.FirstDerivative, 4.0, CubicInterpolation.BoundaryCondition.FirstDerivative, -4.0);
        interpolated = f.op(0.0);
        Assert.assertFalse((String)("MC clamped spline interpolation failed at x = 0.0\n    interpolated value: " + interpolated + "\n    expected value:     " + 0.0 + "\n    error:              " + Math.abs(interpolated - 0.0)), (Math.abs(interpolated - 0.0) > 1.0E-15 ? 1 : 0) != 0);
        f = new CubicInterpolation(x, y, CubicInterpolation.DerivativeApprox.Spline, true, CubicInterpolation.BoundaryCondition.SecondDerivative, -2.0, CubicInterpolation.BoundaryCondition.SecondDerivative, -2.0);
        interpolated = f.op(0.0);
        Assert.assertFalse((String)("MC SecondDerivative spline interpolation failed at x = 0.0\n    interpolated value: " + interpolated + "\n    expected value:     " + 0.0 + "\n    error:              " + Math.abs(interpolated - 0.0)), (Math.abs(interpolated - 0.0) > 1.0E-15 ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void testSabrInterpolation() {
        QL.info("Testing Sabr interpolation...");
        double tolerance = 2.0E-13;
        double[] strikes = new double[31];
        double[] volatilities = new double[31];
        strikes[0] = 0.03;
        strikes[1] = 0.032;
        strikes[2] = 0.034;
        strikes[3] = 0.036;
        strikes[4] = 0.038;
        strikes[5] = 0.04;
        strikes[6] = 0.042;
        strikes[7] = 0.044;
        strikes[8] = 0.046;
        strikes[9] = 0.048;
        strikes[10] = 0.05;
        strikes[11] = 0.052;
        strikes[12] = 0.054;
        strikes[13] = 0.056;
        strikes[14] = 0.058;
        strikes[15] = 0.06;
        strikes[16] = 0.062;
        strikes[17] = 0.064;
        strikes[18] = 0.066;
        strikes[19] = 0.068;
        strikes[20] = 0.07;
        strikes[21] = 0.072;
        strikes[22] = 0.074;
        strikes[23] = 0.076;
        strikes[24] = 0.078;
        strikes[25] = 0.08;
        strikes[26] = 0.082;
        strikes[27] = 0.084;
        strikes[28] = 0.086;
        strikes[29] = 0.088;
        strikes[30] = 0.09;
        volatilities[0] = 1.16725837321531;
        volatilities[1] = 1.15226075991385;
        volatilities[2] = 1.13829711098834;
        volatilities[3] = 1.12524190877505;
        volatilities[4] = 1.11299079244474;
        volatilities[5] = 1.10145609357162;
        volatilities[6] = 1.09056348513411;
        volatilities[7] = 1.08024942745106;
        volatilities[8] = 1.07045919457758;
        volatilities[9] = 1.06114533019077;
        volatilities[10] = 1.05226642581503;
        volatilities[11] = 1.04378614411707;
        volatilities[12] = 1.03567243073732;
        volatilities[13] = 1.0278968727451;
        volatilities[14] = 1.02043417226345;
        volatilities[15] = 1.01326171139321;
        volatilities[16] = 1.00635919013311;
        volatilities[17] = 0.999708323124949;
        volatilities[18] = 0.993292584155381;
        volatilities[19] = 0.987096989695393;
        volatilities[20] = 0.98110791455717;
        volatilities[21] = 0.975312934134512;
        volatilities[22] = 0.969700688771689;
        volatilities[23] = 0.964260766651027;
        volatilities[24] = 0.958983602256592;
        volatilities[25] = 0.953860388001395;
        volatilities[26] = 0.948882997029509;
        volatilities[27] = 0.944043915545469;
        volatilities[28] = 0.939336183299237;
        volatilities[29] = 0.934753341079515;
        volatilities[30] = 0.930289384251337;
        double expiry = 1.0;
        double forward = 0.039;
        double initialAlpha = 0.3;
        double initialBeta = 0.6;
        double initialNu = 0.02;
        double initialRho = 0.01;
        for (int i = 0; i < strikes.length; ++i) {
            double calculatedVol = new Sabr().sabrVolatility(strikes[i], 0.039, 1.0, 0.3, 0.6, 0.02, 0.01);
            Assert.assertFalse((String)("failed to reproduce expected datum\n    expected value:   " + volatilities[i] + "\n    calculated value: " + calculatedVol + "\n    error:              " + Math.abs(calculatedVol - volatilities[i])), (Math.abs(volatilities[i] - calculatedVol) > 2.0E-13 ? 1 : 0) != 0);
        }
        double alphaGuess = Double.MAX_VALUE;
        double betaGuess = Double.MAX_VALUE;
        double nuGuess = Double.MAX_VALUE;
        double rhoGuess = Double.MAX_VALUE;
        boolean[] vegaWeighted = new boolean[]{true, false};
        boolean[] isAlphaFixed = new boolean[]{true, false};
        boolean[] isBetaFixed = new boolean[]{true, false};
        boolean[] isNuFixed = new boolean[]{true, false};
        boolean[] isRhoFixed = new boolean[]{true, false};
        double calibrationTolerance = 5.0E-8;
        OptimizationMethod[] methods = new OptimizationMethod[]{new Simplex(0.01), new LevenbergMarquardt(1.0E-8, 1.0E-8, 1.0E-8)};
        EndCriteria endCriteria = new EndCriteria(100000, 100, 1.0E-8, 1.0E-8, 1.0E-8);
        for (int j = 0; j < methods.length; ++j) {
            for (int i = 0; i < vegaWeighted.length; ++i) {
                for (int k_a = 0; k_a < isAlphaFixed.length; ++k_a) {
                    for (int k_b = 0; k_b < isBetaFixed.length; ++k_b) {
                        for (int k_n = 0; k_n < isNuFixed.length; ++k_n) {
                            for (int k_r = 0; k_r < isRhoFixed.length; ++k_r) {
                                SABRInterpolation sabrInterpolation = new SABRInterpolation(new Array(strikes), new Array(volatilities), 1.0, 0.039, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, isAlphaFixed[k_a], isBetaFixed[k_b], isNuFixed[k_n], isRhoFixed[k_r], vegaWeighted[i], endCriteria, methods[j]);
                                sabrInterpolation.update();
                                boolean failed = false;
                                double calibratedAlpha = sabrInterpolation.alpha();
                                double calibratedBeta = sabrInterpolation.beta();
                                double calibratedNu = sabrInterpolation.nu();
                                double calibratedRho = sabrInterpolation.rho();
                                double error = Math.abs(0.3 - calibratedAlpha);
                                Assert.assertFalse((String)("failed to calibrate alpha Sabr parameter\n    expected value:   0.3\n    calculated value: " + calibratedAlpha + "\n    error:              " + error), (Math.abs(error) > 5.0E-8 ? 1 : 0) != 0);
                                error = Math.abs(0.6 - calibratedBeta);
                                Assert.assertFalse((String)("failed to calibrate beta Sabr parameter\n    expected value:   0.6\n    calculated value: " + calibratedBeta + "\n    error:              " + error), (Math.abs(error) > 5.0E-8 ? 1 : 0) != 0);
                                error = Math.abs(0.02 - calibratedNu);
                                Assert.assertFalse((String)("failed to calibrate nu Sabr parameter\n    expected value:   0.02\n    calculated value: " + calibratedNu + "\n    error:              " + error), (Math.abs(error) > 5.0E-8 ? 1 : 0) != 0);
                                error = Math.abs(0.01 - calibratedRho);
                                Assert.assertFalse((String)("failed to calibrate rho Sabr parameter\n    expected value:   0.01\n    calculated value: " + calibratedRho + "\n    error:              " + error), (Math.abs(error) > 5.0E-8 ? 1 : 0) != 0);
                            }
                        }
                    }
                }
            }
        }
    }

    private Array xRange(double start, double finish, int size) {
        double[] x = new double[size];
        double dx = (finish - start) / (double)(size - 1);
        for (int i = 0; i < size - 1; ++i) {
            x[i] = start + (double)i * dx;
        }
        x[size - 1] = finish;
        return new Array(x);
    }

    private Array gaussian(Array x) {
        double[] y = new double[x.size()];
        for (int i = 0; i < x.size(); ++i) {
            double value = x.get(i);
            y[i] = Math.exp(-value * value);
        }
        return new Array(y);
    }

    private Array parabolic(Array x) {
        double[] y = new double[x.size()];
        for (int i = 0; i < x.size(); ++i) {
            double value = x.get(i);
            y[i] = -value * value;
        }
        return new Array(y);
    }

    private void checkValues(String type, CubicInterpolation spline, Array x, Array y) {
        double tolerance = 2.0E-15;
        for (int i = 0; i < x.size(); ++i) {
            double xval = x.get(i);
            double yval = y.get(i);
            double interpolated = spline.op(xval);
            Assert.assertFalse((String)(type + " interpolation failed at x = " + xval + "\n interpolated value: " + interpolated + "\n expected value:     " + yval + "\n error:        " + Math.abs(interpolated - yval)), (Math.abs(interpolated - yval) > 2.0E-15 ? 1 : 0) != 0);
        }
    }

    private void check1stDerivativeValue(String type, CubicInterpolation spline, double x, double value) {
        double tolerance = 1.0E-14;
        double interpolated = spline.derivative(x);
        Assert.assertFalse((String)(type + " interpolation first derivative failure at x = " + x + "\n interpolated value: " + interpolated + "\n expected value:     " + value + "\n error:        " + Math.abs(interpolated - value)), (Math.abs(interpolated - value) > 1.0E-14 ? 1 : 0) != 0);
    }

    private void check2ndDerivativeValue(String type, CubicInterpolation spline, double x, double value) {
        double tolerance = 1.0E-13;
        double interpolated = spline.secondDerivative(x);
        Assert.assertFalse((String)(type + " interpolation second derivative failure at x = " + x + "\n interpolated value: " + interpolated + "\n expected value:     " + value + "\n error:        " + Math.abs(interpolated - value)), (Math.abs(interpolated - value) > 1.0E-13 ? 1 : 0) != 0);
    }

    private void checkNotAKnotCondition(String type, CubicInterpolation spline) {
        double tolerance = 1.0E-14;
        Array c = spline.cCoefficients();
        Assert.assertFalse((String)(type + " interpolation failure" + "\n    cubic coefficient of the first polinomial is " + c.get(0) + "\n    cubic coefficient of the second polinomial is " + c.get(1)), (Math.abs(c.get(0) - c.get(1)) > 1.0E-14 ? 1 : 0) != 0);
        int n = c.size();
        Assert.assertFalse((String)(type + " interpolation failure" + "\n    cubic coefficient of the 2nd to last polinomial is " + c.get(n - 2) + "\n    cubic coefficient of the last polinomial is " + c.get(n - 1)), (Math.abs(c.get(n - 2) - c.get(n - 1)) > 1.0E-14 ? 1 : 0) != 0);
    }

    private void checkSymmetry(String type, CubicInterpolation spline, double xMin) {
        double tolerance = 1.0E-15;
        for (double x = xMin; x < 0.0; x += 0.1) {
            double y1 = spline.op(x);
            double y2 = spline.op(-x);
            Assert.assertFalse((String)(type + " interpolation not symmetric" + "\n    x = " + x + "\n    g(x)  = " + y1 + "\n    g(-x) = " + y2 + "\n    error:  " + Math.abs(y1 - y2)), (Math.abs(y1 - y2) > 1.0E-15 ? 1 : 0) != 0);
        }
    }

    private ErrorFunction makeErrorFunction(Ops.DoubleOp f) {
        return new ErrorFunction(f);
    }

    private double multif(double s, double t, double u, double v, double w) {
        return Math.sqrt(s * Math.sinh(Math.log(t)) + Math.exp(Math.sin(u) * Math.sin(3.0 * v)) + Math.sinh(Math.log(v * w)));
    }

    private class ErrorFunction
    implements Ops.DoubleOp {
        private final Ops.DoubleOp f;

        public ErrorFunction(Ops.DoubleOp f) {
            this.f = f;
        }

        @Override
        public double op(double x) {
            double temp = this.f.op(x) - Math.exp(-x * x);
            return temp * temp;
        }
    }
}

