/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.factories.ForwardFlat;
import org.jquantlib.math.matrixutilities.Array;
import org.junit.Assert;
import org.junit.Test;

public class FlatForwardInterpolationTest {
    private final Array x = new Array(new double[]{0.0, 1.0, 2.0, 3.0, 4.0});
    private final Array y = new Array(new double[]{5.0, 4.0, 3.0, 2.0, 1.0});
    private final Interpolation interpolation;
    private final int length;
    private final double tolerance;

    public FlatForwardInterpolationTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.interpolation = new ForwardFlat().interpolate(this.x, this.y);
        this.length = this.x.size();
        this.tolerance = 1.0E-12;
    }

    @Test
    public void checkAtOriginalPoints() {
        for (int i = 0; i < this.length; ++i) {
            double d = this.x.get(i);
            double calculated = this.interpolation.op(d);
            double expected = this.y.get(i);
            Assert.assertFalse((String)("failed to reproduce " + i + " datum" + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkAtMiddlePoints() {
        for (int i = 0; i < this.length - 1; ++i) {
            double d = (this.x.get(i) + this.x.get(i + 1)) / 2.0;
            double calculated = this.interpolation.op(d);
            double expected = this.y.get(i);
            Assert.assertFalse((String)("failed to interpolate correctly at " + d + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkOutsideOriginalRange() {
        this.interpolation.enableExtrapolation();
        double d = this.x.first() - 0.5;
        double calculated = this.interpolation.op(d);
        double expected = this.y.first();
        Assert.assertFalse((String)("failed to extrapolate correctly at " + d + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        d = this.x.last() + 0.5;
        calculated = this.interpolation.op(d);
        expected = this.y.last();
        Assert.assertFalse((String)("failed to extrapolate correctly at " + d + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
    }

    @Test
    public void checkPrimitiveAtOriginalPoints() {
        double calculated = this.interpolation.primitive(this.x.first());
        double expected = 0.0;
        Assert.assertFalse((String)("failed to calculate primitive at " + this.x.first() + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        double sum = 0.0;
        for (int i = 1; i < this.length; ++i) {
            calculated = this.interpolation.primitive(this.x.get(i));
            expected = sum += (this.x.get(i) - this.x.get(i - 1)) * this.y.get(i - 1);
            Assert.assertFalse((String)("failed to calculate primitive at " + this.x.get(i) + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }

    @Test
    public void checkPrimitiveAtMiddlePoints() {
        double sum = 0.0;
        for (int i = 0; i < this.length - 1; ++i) {
            double d = (this.x.get(i) + this.x.get(i + 1)) / 2.0;
            double calculated = this.interpolation.primitive(d);
            double expected = sum += (this.x.get(i + 1) - this.x.get(i)) * this.y.get(i) / 2.0;
            sum += (this.x.get(i + 1) - this.x.get(i)) * this.y.get(i) / 2.0;
            Assert.assertFalse((String)("failed to calculate primitive at " + d + "\n expected:     " + expected + "\n calculated:   " + calculated + "\n error:        " + Math.abs(expected - calculated)), (Math.abs(expected - calculated) > this.tolerance ? 1 : 0) != 0);
        }
    }
}

