/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.daycounters;

import java.util.HashSet;
import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.ActualActual;
import org.jquantlib.daycounters.Business252;
import org.jquantlib.daycounters.SimpleDayCounter;
import org.jquantlib.daycounters.Thirty360;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Brazil;
import org.jquantlib.time.calendars.China;
import org.junit.Assert;
import org.junit.Test;

public class DayCountersTest {
    public DayCountersTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testActualActual() {
        QL.info("Testing actual/actual day counters...");
        SingleCase[] testCases = new SingleCase[]{new SingleCase(ActualActual.Convention.ISDA, new Date(1, Month.November, 2003), new Date(1, Month.May, 2004), 0.497724380567), new SingleCase(ActualActual.Convention.ISMA, new Date(1, Month.November, 2003), new Date(1, Month.May, 2004), new Date(1, Month.November, 2003), new Date(1, Month.May, 2004), 0.5), new SingleCase(ActualActual.Convention.AFB, new Date(1, Month.November, 2003), new Date(1, Month.May, 2004), 0.497267759563), new SingleCase(ActualActual.Convention.ISDA, new Date(1, Month.February, 1999), new Date(1, Month.July, 1999), 0.41095890411), new SingleCase(ActualActual.Convention.ISMA, new Date(1, Month.February, 1999), new Date(1, Month.July, 1999), new Date(1, Month.July, 1998), new Date(1, Month.July, 1999), 0.41095890411), new SingleCase(ActualActual.Convention.AFB, new Date(1, Month.February, 1999), new Date(1, Month.July, 1999), 0.41095890411), new SingleCase(ActualActual.Convention.ISDA, new Date(1, Month.July, 1999), new Date(1, Month.July, 2000), 1.0013773486), new SingleCase(ActualActual.Convention.ISMA, new Date(1, Month.July, 1999), new Date(1, Month.July, 2000), new Date(1, Month.July, 1999), new Date(1, Month.July, 2000), 1.0), new SingleCase(ActualActual.Convention.AFB, new Date(1, Month.July, 1999), new Date(1, Month.July, 2000), 1.0), new SingleCase(ActualActual.Convention.ISDA, new Date(15, Month.August, 2002), new Date(15, Month.July, 2003), 0.915068493151), new SingleCase(ActualActual.Convention.ISMA, new Date(15, Month.August, 2002), new Date(15, Month.July, 2003), new Date(15, Month.January, 2003), new Date(15, Month.July, 2003), 0.915760869565), new SingleCase(ActualActual.Convention.AFB, new Date(15, Month.August, 2002), new Date(15, Month.July, 2003), 0.915068493151), new SingleCase(ActualActual.Convention.ISDA, new Date(15, Month.July, 2003), new Date(15, Month.January, 2004), 0.504004790778), new SingleCase(ActualActual.Convention.ISMA, new Date(15, Month.July, 2003), new Date(15, Month.January, 2004), new Date(15, Month.July, 2003), new Date(15, Month.January, 2004), 0.5), new SingleCase(ActualActual.Convention.AFB, new Date(15, Month.July, 2003), new Date(15, Month.January, 2004), 0.504109589041), new SingleCase(ActualActual.Convention.ISDA, new Date(30, Month.July, 1999), new Date(30, Month.January, 2000), 0.503892506924), new SingleCase(ActualActual.Convention.ISMA, new Date(30, Month.July, 1999), new Date(30, Month.January, 2000), new Date(30, Month.July, 1999), new Date(30, Month.January, 2000), 0.5), new SingleCase(ActualActual.Convention.AFB, new Date(30, Month.July, 1999), new Date(30, Month.January, 2000), 0.504109589041), new SingleCase(ActualActual.Convention.ISDA, new Date(30, Month.January, 2000), new Date(30, Month.June, 2000), 0.415300546448), new SingleCase(ActualActual.Convention.ISMA, new Date(30, Month.January, 2000), new Date(30, Month.June, 2000), new Date(30, Month.January, 2000), new Date(30, Month.July, 2000), 0.417582417582), new SingleCase(ActualActual.Convention.AFB, new Date(30, Month.January, 2000), new Date(30, Month.June, 2000), 0.41530054644)};
        for (int i = 0; i < testCases.length - 1; ++i) {
            ActualActual dayCounter = new ActualActual(testCases[i].convention);
            Date d1 = testCases[i].start;
            Date d2 = testCases[i].end;
            Date rd1 = testCases[i].refStart;
            Date rd2 = testCases[i].refEnd;
            QL.info(testCases[i].toString());
            double calculated = dayCounter.yearFraction(d1, d2, rd1, rd2);
            if (!(Math.abs(calculated - testCases[i].result) > 1.0E-10)) continue;
            String period = "period: " + d1 + " to " + d2;
            String refPeriod = "";
            if (testCases[i].convention == ActualActual.Convention.ISMA) {
                refPeriod = "referencePeriod: " + rd1 + " to " + rd2;
            }
            Assert.fail((String)(dayCounter.name() + ":\n" + period + "\n" + refPeriod + "\n" + "    calculated: " + calculated + "\n" + "    expected:   " + testCases[i].result));
        }
    }

    @Test
    public void testSimple() {
        QL.info("Testing simple day counter...");
        Period[] p = new Period[]{new Period(3, TimeUnit.Months), new Period(6, TimeUnit.Months), new Period(1, TimeUnit.Years)};
        double[] expected = new double[]{0.25, 0.5, 1.0};
        Date first = new Date(1, Month.January, 2002);
        Date last = new Date(31, Month.December, 2005);
        SimpleDayCounter dayCounter = new SimpleDayCounter();
        Date start = first;
        while (start.le(last)) {
            for (int i = 0; i < expected.length - 1; ++i) {
                Date end = start.add(p[i]);
                double calculated = dayCounter.yearFraction(start, end);
                if (!(Math.abs(calculated - expected[i]) > 1.0E-12)) continue;
                Assert.fail((String)("from " + start + " to " + end + ":\n" + "    calculated: " + calculated + "\n" + "    expected:   " + expected[i]));
            }
            start.inc();
        }
    }

    @Test
    public void testOne() {
        QL.info("Testing 1/1 day counter...");
        Period[] p = new Period[]{new Period(3, TimeUnit.Months), new Period(6, TimeUnit.Months), new Period(1, TimeUnit.Years)};
        double[] expected = new double[]{1.0, 1.0, 1.0};
        Date first = new Date(1, Month.January, 2004);
        Date last = new Date(31, Month.December, 2004);
        SimpleDayCounter dayCounter = new SimpleDayCounter();
        Date start = first;
        while (start.le(last)) {
            for (int i = 0; i < expected.length - 1; ++i) {
                Date end = start.add(p[i]);
                double calculated = dayCounter.yearFraction(start, end);
                if (!(Math.abs(calculated - expected[i]) <= 1.0E-12)) continue;
                Assert.fail((String)("from " + start + " to " + end + ":\n" + "    calculated: " + calculated + "\n" + "    expected:   " + expected[i]));
            }
            start.inc();
        }
    }

    @Test
    public void testBusiness252() {
        QL.info("Testing business/252 day counter...");
        Date[] testDates = new Date[]{new Date(1, Month.February, 2002), new Date(4, Month.February, 2002), new Date(16, Month.May, 2003), new Date(17, Month.December, 2003), new Date(17, Month.December, 2004), new Date(19, Month.December, 2005), new Date(2, Month.January, 2006), new Date(13, Month.March, 2006), new Date(15, Month.May, 2006), new Date(17, Month.March, 2006), new Date(15, Month.May, 2006), new Date(26, Month.July, 2006)};
        double[] expected = new double[]{0.0039682539683, 1.2738095238095, 0.6031746031746, 0.9960317460317, 1.0, 0.0396825396825, 0.1904761904762, 0.1666666666667, -0.1507936507937, 0.1507936507937, 0.202380952381};
        Business252 dayCounter = new Business252(new Brazil(Brazil.Market.SETTLEMENT));
        for (int i = 1; i < testDates.length - 1; ++i) {
            Date start = testDates[i - 1];
            Date end = testDates[i];
            double calculated = dayCounter.yearFraction(start, end);
            Assert.assertFalse((String)(dayCounter.getClass().getName() + "\n from " + start + "\n to " + end + "\n calculated: " + calculated + "\n expected:   " + expected[i]), (Math.abs(calculated - expected[i]) <= 1.0E-12 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEqualityHashCode() {
        QL.info("Testing Equality and HashCode ...");
        Business252 business252Brazil = new Business252(new Brazil(Brazil.Market.SETTLEMENT));
        Business252 business252Brazil1 = new Business252(new Brazil(Brazil.Market.SETTLEMENT));
        Business252 business252China = new Business252(new China(China.Market.SSE));
        SimpleDayCounter simpleDayCounter = new SimpleDayCounter();
        Actual360 actual360 = new Actual360();
        Actual365Fixed actual365Fixed = new Actual365Fixed();
        ActualActual actualActual = new ActualActual();
        Thirty360 thirty360 = new Thirty360();
        Thirty360 thirty360_2 = new Thirty360();
        Assert.assertFalse((boolean)thirty360.equals(null));
        Assert.assertEquals((Object)thirty360, (Object)thirty360);
        Assert.assertEquals((Object)thirty360, (Object)thirty360_2);
        Assert.assertFalse((boolean)simpleDayCounter.equals(business252Brazil));
        Assert.assertFalse((boolean)business252Brazil.equals(simpleDayCounter));
        Assert.assertFalse((boolean)actual360.equals(actual365Fixed));
        Assert.assertFalse((boolean)actual365Fixed.equals(actual360));
        Assert.assertFalse((boolean)actualActual.equals(thirty360));
        Assert.assertFalse((boolean)thirty360.equals(actualActual));
        Assert.assertFalse((boolean)business252Brazil.equals(business252China));
        Assert.assertFalse((boolean)business252China.equals(business252Brazil));
        Assert.assertTrue((boolean)business252Brazil.equals(business252Brazil1));
        Assert.assertTrue((boolean)business252Brazil.eq(business252Brazil1));
        Assert.assertFalse((boolean)business252Brazil.ne(business252Brazil1));
        HashSet<Thirty360> testSet = new HashSet<Thirty360>();
        testSet.add(thirty360);
        Assert.assertTrue((boolean)testSet.contains(thirty360));
        Assert.assertFalse((boolean)testSet.contains(actualActual));
    }

    private static class SingleCase {
        private final ActualActual.Convention convention;
        private final Date start;
        private final Date end;
        private final Date refStart;
        private final Date refEnd;
        private final double result;

        public SingleCase(ActualActual.Convention convention, Date start, Date end, double result) {
            this(convention, start, end, new Date(), new Date(), result);
        }

        public SingleCase(ActualActual.Convention convention, Date start, Date end, Date refStart, Date refEnd, double result) {
            this.convention = convention;
            this.start = start;
            this.end = end;
            this.refStart = refStart;
            this.refEnd = refEnd;
            this.result = result;
        }

        private String dumpDate(Date date) {
            if (date == null || date.isNull()) {
                return "null";
            }
            return date.isoDate().toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            sb.append((Object)this.convention).append(", ");
            sb.append(this.dumpDate(this.start)).append(", ");
            sb.append(this.dumpDate(this.end)).append(", ");
            sb.append(this.dumpDate(this.refStart)).append(", ");
            sb.append(this.dumpDate(this.refEnd));
            sb.append(" ]");
            return sb.toString();
        }
    }
}

