/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Target;
import org.junit.Assert;
import org.junit.Test;

public class TestCalendarReferences {
    @Test
    public void testCalendarAdvance() {
        Target calendar = new Target();
        Date today = new Date(20, Month.June, 2008);
        Period thirtyYears = new Period(30, TimeUnit.Years);
        Date nextDate = calendar.advance(today, new Period(1, TimeUnit.Days));
        Assert.assertNotSame((Object)today, (Object)nextDate);
        nextDate = calendar.advance(today, 10, TimeUnit.Days);
        Assert.assertNotSame((Object)today, (Object)nextDate);
        nextDate = calendar.advance(today, thirtyYears, BusinessDayConvention.Following);
        Assert.assertNotSame((Object)today, (Object)nextDate);
        nextDate = calendar.advance(today, thirtyYears, BusinessDayConvention.Following, true);
        Assert.assertNotSame((Object)today, (Object)nextDate);
        nextDate = calendar.advance(today, 10, TimeUnit.Days, BusinessDayConvention.Following, true);
        Assert.assertNotSame((Object)today, (Object)nextDate);
    }

    @Test
    public void testCalendarAdjust() {
        Target calendar = new Target();
        Date today = new Date(20, Month.June, 2008);
        Date nextDate = calendar.adjust(today, BusinessDayConvention.Following);
        Assert.assertEquals((Object)today, (Object)nextDate);
    }
}

