/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.Vector;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Indonesia;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IndonesiaCalendarTest {
    private Calendar c = null;

    public IndonesiaCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Before
    public void setUp() {
        this.c = new Indonesia(Indonesia.Market.BEJ);
    }

    @Test
    public void testIndonesiaYear2009() {
        int year = 2009;
        QL.info("Testing Indonesia's holiday list for the year 2009...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(2, Month.January, 2009));
        expectedHol.add(new Date(26, Month.January, 2009));
        expectedHol.add(new Date(9, Month.March, 2009));
        expectedHol.add(new Date(26, Month.March, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(21, Month.May, 2009));
        expectedHol.add(new Date(20, Month.July, 2009));
        expectedHol.add(new Date(17, Month.August, 2009));
        expectedHol.add(new Date(18, Month.September, 2009));
        expectedHol.add(new Date(21, Month.September, 2009));
        expectedHol.add(new Date(22, Month.September, 2009));
        expectedHol.add(new Date(23, Month.September, 2009));
        expectedHol.add(new Date(27, Month.November, 2009));
        expectedHol.add(new Date(18, Month.December, 2009));
        expectedHol.add(new Date(24, Month.December, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        expectedHol.add(new Date(31, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2009);
    }

    @Test
    public void testIndonesiaYear2008() {
        int year = 2008;
        QL.info("Testing Indonesia's holiday list for the year 2008...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(10, Month.January, 2008));
        expectedHol.add(new Date(11, Month.January, 2008));
        expectedHol.add(new Date(7, Month.February, 2008));
        expectedHol.add(new Date(8, Month.February, 2008));
        expectedHol.add(new Date(7, Month.March, 2008));
        expectedHol.add(new Date(20, Month.March, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(20, Month.May, 2008));
        expectedHol.add(new Date(30, Month.July, 2008));
        expectedHol.add(new Date(18, Month.August, 2008));
        expectedHol.add(new Date(30, Month.September, 2008));
        expectedHol.add(new Date(1, Month.October, 2008));
        expectedHol.add(new Date(2, Month.October, 2008));
        expectedHol.add(new Date(3, Month.October, 2008));
        expectedHol.add(new Date(8, Month.December, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(29, Month.December, 2008));
        expectedHol.add(new Date(31, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2008);
    }

    @Test
    public void testIndonesiaYear2007() {
        int year = 2007;
        QL.info("Testing Indonesia's holiday list for the year 2007...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(19, Month.March, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(17, Month.May, 2007));
        expectedHol.add(new Date(18, Month.May, 2007));
        expectedHol.add(new Date(1, Month.June, 2007));
        expectedHol.add(new Date(17, Month.August, 2007));
        expectedHol.add(new Date(12, Month.October, 2007));
        expectedHol.add(new Date(15, Month.October, 2007));
        expectedHol.add(new Date(16, Month.October, 2007));
        expectedHol.add(new Date(24, Month.October, 2007));
        expectedHol.add(new Date(20, Month.December, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(10, Month.January, 2007));
        expectedHol.add(new Date(11, Month.January, 2007));
        expectedHol.add(new Date(7, Month.February, 2007));
        expectedHol.add(new Date(8, Month.February, 2007));
        expectedHol.add(new Date(7, Month.March, 2007));
        expectedHol.add(new Date(20, Month.March, 2007));
        expectedHol.add(new Date(30, Month.July, 2007));
        expectedHol.add(new Date(1, Month.October, 2007));
        expectedHol.add(new Date(2, Month.October, 2007));
        expectedHol.add(new Date(3, Month.October, 2007));
        expectedHol.add(new Date(31, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2007);
    }

    @Test
    public void testIndonesiaYear2006() {
        int year = 2006;
        QL.info("Testing Indonesia's holiday list for the year 2006...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(10, Month.January, 2006));
        expectedHol.add(new Date(31, Month.January, 2006));
        expectedHol.add(new Date(30, Month.March, 2006));
        expectedHol.add(new Date(10, Month.April, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(25, Month.May, 2006));
        expectedHol.add(new Date(17, Month.August, 2006));
        expectedHol.add(new Date(21, Month.August, 2006));
        expectedHol.add(new Date(23, Month.October, 2006));
        expectedHol.add(new Date(24, Month.October, 2006));
        expectedHol.add(new Date(25, Month.October, 2006));
        expectedHol.add(new Date(26, Month.October, 2006));
        expectedHol.add(new Date(27, Month.October, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2006);
    }

    @Test
    public void testIndonesiaYear2005() {
        int year = 2005;
        QL.info("Testing Indonesia's holiday list for the year 2005...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(21, Month.January, 2005));
        expectedHol.add(new Date(9, Month.February, 2005));
        expectedHol.add(new Date(10, Month.February, 2005));
        expectedHol.add(new Date(11, Month.March, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(22, Month.April, 2005));
        expectedHol.add(new Date(5, Month.May, 2005));
        expectedHol.add(new Date(24, Month.May, 2005));
        expectedHol.add(new Date(17, Month.August, 2005));
        expectedHol.add(new Date(2, Month.September, 2005));
        expectedHol.add(new Date(2, Month.November, 2005));
        expectedHol.add(new Date(3, Month.November, 2005));
        expectedHol.add(new Date(4, Month.November, 2005));
        expectedHol.add(new Date(7, Month.November, 2005));
        expectedHol.add(new Date(8, Month.November, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2005);
    }

    @After
    public void destroy() {
        this.c = null;
    }
}

