/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.IMM;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;

public class FuturesRateHelper
extends RateHelper {
    private static final String NOT_A_VALID_IMM_DATE = "not a valid IMM date";
    private static final String TERMSTRUCT_NOT_SET = "term structure not set";
    private final double yearFraction;
    private Handle<Quote> convAdj;

    public FuturesRateHelper(Handle<Quote> price, Date immDate, int lengthInMonths, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        this(price, immDate, lengthInMonths, calendar, convention, endOfMonth, dayCounter, new Handle<Quote>());
    }

    public FuturesRateHelper(Handle<Quote> price, Date immDate, int lengthInMonths, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter, Handle<Quote> convAdj) {
        super(price);
        this.convAdj = convAdj;
        new IMM();
        QL.require(IMM.isIMMdate(immDate, false), NOT_A_VALID_IMM_DATE);
        this.earliestDate = immDate;
        this.latestDate = calendar.advance(immDate, new Period(lengthInMonths, TimeUnit.Months), convention, endOfMonth);
        this.yearFraction = dayCounter.yearFraction(this.earliestDate, this.latestDate);
        convAdj.addObserver(this);
    }

    public FuturesRateHelper(double price, Date immDate, int lengthInMonths, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        this(price, immDate, lengthInMonths, calendar, convention, endOfMonth, dayCounter, 0.0);
    }

    public FuturesRateHelper(double price, Date immDate, int lengthInMonths, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter, double convAdj) {
        super(price);
        this.convAdj = new Handle<SimpleQuote>(new SimpleQuote(convAdj));
        new IMM();
        QL.require(IMM.isIMMdate(immDate, false), NOT_A_VALID_IMM_DATE);
        this.earliestDate = immDate;
        this.latestDate = calendar.advance(immDate, new Period(lengthInMonths, TimeUnit.Months), convention, endOfMonth);
        this.yearFraction = dayCounter.yearFraction(this.earliestDate, this.latestDate);
    }

    public FuturesRateHelper(Handle<Quote> price, Date immDate, IborIndex i) {
        this(price, immDate, i, new Handle<Quote>());
    }

    public FuturesRateHelper(Handle<Quote> price, Date immDate, IborIndex i, Handle<Quote> convAdj) {
        super(price);
        this.convAdj = convAdj;
        new IMM();
        QL.require(IMM.isIMMdate(immDate, false), NOT_A_VALID_IMM_DATE);
        this.earliestDate = immDate;
        this.latestDate = i.fixingCalendar().advance(immDate, i.tenor(), i.businessDayConvention());
        this.yearFraction = i.dayCounter().yearFraction(this.earliestDate, this.latestDate);
        convAdj.addObserver(this);
    }

    public FuturesRateHelper(double price, Date immDate, IborIndex i) {
        this(price, immDate, i, 0.0);
    }

    public FuturesRateHelper(double price, Date immDate, IborIndex i, double convAdj) {
        super(price);
        this.convAdj = new Handle<SimpleQuote>(new SimpleQuote(convAdj));
        new IMM();
        QL.require(IMM.isIMMdate(immDate, false), NOT_A_VALID_IMM_DATE);
        this.earliestDate = immDate;
        Calendar cal = i.fixingCalendar();
        this.latestDate = cal.advance(immDate, i.tenor(), i.businessDayConvention());
        this.yearFraction = i.dayCounter().yearFraction(this.earliestDate, this.latestDate);
    }

    @Override
    public double impliedQuote() {
        QL.require(this.termStructure != null, TERMSTRUCT_NOT_SET);
        double forwardRate = ((YieldTermStructure)this.termStructure).discount(this.earliestDate) / (((YieldTermStructure)this.termStructure).discount(this.latestDate) - 1.0) / this.yearFraction;
        double convA = this.convAdj.empty() ? 0.0 : this.convAdj.currentLink().value();
        QL.ensure(convA >= 0.0, "Negative (" + this.convAdj + ") futures convexity adjustment");
        double futureRate = forwardRate + convA;
        return 100.0 * (1.0 - futureRate);
    }

    public double getConvexityAdjustment() {
        return this.convAdj.empty() ? 0.0 : this.convAdj.currentLink().value();
    }
}

