/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.AbstractYieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.calendars.Target;

public abstract class ForwardRateStructure
extends AbstractYieldTermStructure {
    protected ForwardRateStructure() {
        this(new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    protected ForwardRateStructure(DayCounter dc) {
        super(dc);
        QL.validateExperimentalMode();
    }

    protected ForwardRateStructure(Date refDate, Calendar cal) {
        this(refDate, cal, (DayCounter)new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    protected ForwardRateStructure(Date refDate, DayCounter dc) {
        this(refDate, (Calendar)new Target(), dc);
        QL.validateExperimentalMode();
    }

    protected ForwardRateStructure(Date refDate) {
        this(refDate, (Calendar)new Target(), (DayCounter)new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    protected ForwardRateStructure(Date refDate, Calendar cal, DayCounter dc) {
        super(refDate, cal, dc);
        QL.validateExperimentalMode();
    }

    protected ForwardRateStructure(int settlementDays, Calendar cal) {
        super(settlementDays, cal, (DayCounter)new Actual365Fixed());
        QL.validateExperimentalMode();
    }

    protected ForwardRateStructure(int settlementDays, Calendar cal, DayCounter dc) {
        super(settlementDays, cal, dc);
        QL.validateExperimentalMode();
    }

    protected abstract double forwardImpl(double var1);

    protected double zeroYieldImpl(double t) {
        double dt;
        if (t == 0.0) {
            return this.forwardImpl(0.0);
        }
        double sum = 0.5 * this.forwardImpl(0.0);
        int n = 1000;
        for (double i = dt = t / 1000.0; i < t; i += dt) {
            sum += this.forwardImpl(i);
        }
        return (sum += 0.5 * this.forwardImpl(t)) * dt / t;
    }

    @Override
    public double discountImpl(double t) {
        double r = this.zeroYieldImpl(t);
        return Math.exp(-r * t);
    }
}

