/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.LocalVolTermStructure;
import org.jquantlib.termstructures.volatilities.BlackVarianceCurve;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class LocalVolCurve
extends LocalVolTermStructure {
    private final BlackVarianceCurve blackVarianceCurve;

    public LocalVolCurve(Handle<BlackVarianceCurve> curve) {
        super(curve.currentLink().calendar(), curve.currentLink().businessDayConvention(), curve.currentLink().dayCounter());
        this.blackVarianceCurve = curve.currentLink();
        this.blackVarianceCurve.addObserver(this);
    }

    @Override
    public final Date referenceDate() {
        return this.blackVarianceCurve.referenceDate();
    }

    @Override
    public final DayCounter dayCounter() {
        return this.blackVarianceCurve.dayCounter();
    }

    @Override
    public final Date maxDate() {
        return this.blackVarianceCurve.maxDate();
    }

    @Override
    public final double minStrike() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public final double maxStrike() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected final double localVolImpl(double maturity, double strike) {
        double m = maturity;
        double dt = 0.0027397260273972603;
        double var1 = this.blackVarianceCurve.blackVariance(maturity, strike, true);
        double var2 = this.blackVarianceCurve.blackVariance(m + 0.0027397260273972603, strike, true);
        double derivative = (var2 - var1) / 0.0027397260273972603;
        return Math.sqrt(derivative);
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

