/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.annotation.Natural;
import org.jquantlib.lang.annotation.Rate;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.InflationTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;

public abstract class YoYInflationTermStructure
extends InflationTermStructure {
    public YoYInflationTermStructure(DayCounter dayCounter, Period lag, Frequency frequency, @Rate double baseYoYRate, Handle<YieldTermStructure> yTS) {
        super(lag, frequency, baseYoYRate, yTS, dayCounter);
    }

    public YoYInflationTermStructure(Date referenceDate, Calendar calendar, DayCounter dayCounter, Period lag, Frequency frequency, @Rate double baseYoYRate, Handle<YieldTermStructure> yTS) {
        super(referenceDate, lag, frequency, baseYoYRate, yTS, calendar, dayCounter);
    }

    public YoYInflationTermStructure(@Natural int settlementDays, Calendar calendar, DayCounter dayCounter, Period lag, Frequency frequency, @Rate double baseYoYRate, Handle<YieldTermStructure> yTS) {
        super(settlementDays, calendar, lag, frequency, baseYoYRate, yTS, dayCounter);
    }

    public double yoyRate(Date date) {
        return this.yoyRate(date, false);
    }

    public double yoyRate(Date date, boolean extrapolate) {
        this.checkRange(date, extrapolate);
        return this.yoyRate(this.timeFromReference(date));
    }

    public double yoyRate(@Time double time) {
        return this.yoyRate(time, false);
    }

    public double yoyRate(@Time double time, boolean extrapolate) {
        this.checkRange(time, extrapolate);
        return this.yoyRateImpl(time);
    }

    protected abstract double yoyRateImpl(@Time double var1);
}

