/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Ops;
import org.jquantlib.termstructures.RateHelper;
import org.jquantlib.termstructures.yieldcurves.PiecewiseCurve;
import org.jquantlib.termstructures.yieldcurves.Traits;

public class BootstrapError<T extends Traits>
implements Ops.DoubleOp {
    private final PiecewiseCurve curve;
    private final Traits traits;
    private final RateHelper helper;
    private final int segment;

    public BootstrapError(Class<?> klass, PiecewiseCurve curve, RateHelper helper, int segment) {
        this(BootstrapError.constructTraits(klass), curve, helper, segment);
    }

    public BootstrapError(Traits traits, PiecewiseCurve c, RateHelper helper, int segment) {
        QL.validateExperimentalMode();
        if (!Traits.class.isAssignableFrom(traits.getClass())) {
            throw new LibraryException("Unexpected type for type parameter");
        }
        this.traits = traits;
        this.curve = c;
        this.segment = segment;
        this.helper = helper;
    }

    @Override
    public double op(double guess) {
        this.traits.updateGuess(this.curve.data(), guess, this.segment);
        this.curve.interpolation().update();
        return this.helper.quoteError();
    }

    private static Traits constructTraits(Class<?> klass) {
        if (klass == null) {
            throw new LibraryException("null Traits");
        }
        if (klass != Traits.class) {
            throw new LibraryException("Unexpected type for type parameter");
        }
        try {
            return (Traits)klass.newInstance();
        }
        catch (Exception e) {
            throw new LibraryException("cannot create Traits", e);
        }
    }
}

