/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.quotes;

import java.util.List;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;
import org.jquantlib.util.WeakReferenceObservable;

public class Handle<T extends Observable>
implements Observable {
    private static final String EMPTY_HANDLE = "empty Handle cannot be dereferenced";
    private final Link link = new Link(this);
    private T observable;
    private boolean isObserver = false;

    public Handle() {
        this.observable = null;
        this.isObserver = true;
    }

    public Handle(T observable) {
        this.internalLinkTo(observable, true);
    }

    public Handle(T observable, boolean registerAsObserver) {
        this.internalLinkTo(observable, registerAsObserver);
    }

    public final boolean empty() {
        return this.observable == null;
    }

    public final T currentLink() {
        return this.observable;
    }

    public void linkTo(T observable) {
        throw new UnsupportedOperationException();
    }

    public void linkTo(T observable, boolean registerAsObserver) {
        throw new UnsupportedOperationException();
    }

    protected final void internalLinkTo(T observable) {
        this.internalLinkTo(observable, true);
    }

    protected final void internalLinkTo(T observable, boolean registerAsObserver) {
        if (this.observable != observable || this.isObserver != registerAsObserver) {
            if (this.observable != null && this.isObserver) {
                this.observable.deleteObserver(this.link);
            }
            this.observable = observable;
            this.isObserver = registerAsObserver;
            if (this.observable != null && this.isObserver) {
                this.observable.addObserver(this.link);
            }
            if (this.observable != null) {
                this.observable.notifyObservers();
            }
        }
    }

    public String toString() {
        return this.observable == null ? "null" : this.observable.toString();
    }

    @Override
    public final void addObserver(Observer observer) {
        this.link.addObserver(observer);
    }

    @Override
    public final int countObservers() {
        return this.link.countObservers();
    }

    @Override
    public final void deleteObserver(Observer observer) {
        this.link.deleteObserver(observer);
    }

    @Override
    public final void notifyObservers() {
        this.link.notifyObservers();
    }

    @Override
    public final void notifyObservers(Object arg) {
        this.link.notifyObservers(arg);
    }

    @Override
    public final void deleteObservers() {
        this.link.deleteObservers();
    }

    @Override
    public final List<Observer> getObservers() {
        return this.link.getObservers();
    }

    private final class Link
    extends WeakReferenceObservable
    implements Observer {
        private Link(Observable observable) {
            super(observable);
        }

        @Override
        public void update() {
            if (Handle.this.observable != null) {
                super.notifyObservers();
            }
        }
    }
}

