/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.Event;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.math.SampledCurve;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.NullCondition;
import org.jquantlib.methods.finitedifferences.StandardFiniteDifferenceModel;
import org.jquantlib.methods.finitedifferences.StepCondition;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDVanillaEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public abstract class FDMultiPeriodEngine
extends FDVanillaEngine {
    protected List<Event> events;
    protected List<Double> stoppingTimes = new ArrayList<Double>();
    protected SampledCurve prices;
    protected StepCondition<Array> stepCondition;
    protected StandardFiniteDifferenceModel model;
    private final int timeStepPerPeriod;

    public FDMultiPeriodEngine(GeneralizedBlackScholesProcess process) {
        this(process, 100, 100, false);
    }

    public FDMultiPeriodEngine(GeneralizedBlackScholesProcess process, int gridPoints, int timeSteps, boolean timeDependent) {
        super(process, gridPoints, timeSteps, timeDependent);
        this.timeStepPerPeriod = timeSteps;
    }

    public void setupArguments(PricingEngine.Arguments args, List<Event> schedule) {
        super.setupArguments(args);
        this.events = schedule;
        this.stoppingTimes.clear();
        int n = schedule.size();
        for (int i = 0; i < n; ++i) {
            this.stoppingTimes.add(this.process.time(this.events.get(i).date()));
        }
    }

    protected abstract void executeIntermediateStep(int var1);

    protected double getDividendTime(int i) {
        return this.stoppingTimes.get(i);
    }

    protected void initializeModel() {
        this.model = new StandardFiniteDifferenceModel(this.finiteDifferenceOperator, this.bcS);
    }

    protected void initializeStepCondition() {
        this.stepCondition = new NullCondition<Array>();
    }

    @Override
    protected void setupArguments(PricingEngine.Arguments a) {
        super.setupArguments(a);
        OneAssetOption.ArgumentsImpl args = (OneAssetOption.ArgumentsImpl)a;
        this.events.clear();
        int n = args.exercise.size();
        for (int i = 0; i < n; ++i) {
            this.stoppingTimes.add(this.process.time(args.exercise.date(i)));
        }
    }

    @Override
    public void calculate(PricingEngine.Results results) {
        double dt;
        OneAssetOption.ResultsImpl r = (OneAssetOption.ResultsImpl)results;
        Option.GreeksImpl greeks = r.greeks();
        int dateNumber = this.stoppingTimes.size();
        boolean lastDateIsResTime = false;
        int firstIndex = -1;
        int lastIndex = dateNumber - 1;
        boolean firstDateIsZero = false;
        double firstNonZeroDate = this.getResidualTime();
        double dateTolerance = 1.0E-6;
        if (dateNumber > 0) {
            QL.require(this.getDividendTime(0) >= 0.0, "first date cannot be negative");
            if (this.getDividendTime(0) < this.getResidualTime() * 1.0E-6) {
                firstDateIsZero = true;
                firstIndex = 0;
                if (dateNumber >= 2) {
                    firstNonZeroDate = this.getDividendTime(1);
                }
            }
            if (Math.abs(this.getDividendTime(lastIndex) - this.getResidualTime()) < 1.0E-6) {
                lastDateIsResTime = true;
                lastIndex = dateNumber - 2;
            }
            if (!firstDateIsZero) {
                firstNonZeroDate = this.getDividendTime(0);
            }
            if (dateNumber >= 2) {
                for (int j = 1; j < dateNumber; ++j) {
                    QL.require(this.getDividendTime(j - 1) < this.getDividendTime(j), "dates must be in strictly increasing order");
                }
            }
        }
        if (firstNonZeroDate <= (dt = this.getResidualTime() / (double)(this.timeStepPerPeriod * (dateNumber + 1)))) {
            dt = firstNonZeroDate / 2.0;
        }
        this.setGridLimits();
        this.initializeInitialCondition();
        this.initializeOperator();
        this.initializeBoundaryConditions();
        this.initializeModel();
        this.initializeStepCondition();
        this.prices = this.intrinsicValues.clone();
        if (lastDateIsResTime) {
            this.executeIntermediateStep(dateNumber - 1);
        }
        int j = lastIndex;
        do {
            double beginDate = j == dateNumber - 1 ? this.getResidualTime() : this.getDividendTime(j + 1);
            double endDate = j >= 0 ? this.getDividendTime(j) : dt;
            this.prices.setValues(this.model.rollback(this.prices.values(), beginDate, endDate, this.timeStepPerPeriod, this.stepCondition));
            if (j < 0) continue;
            this.executeIntermediateStep(j);
        } while (--j >= firstIndex);
        this.prices.setValues(this.model.rollback(this.prices.values(), dt, 0.0, 1, this.stepCondition));
        if (firstDateIsZero) {
            this.executeIntermediateStep(0);
        }
        r.value = this.prices.valueAtCenter();
        greeks.delta = this.prices.firstDerivativeAtCenter();
        greeks.gamma = this.prices.secondDerivativeAtCenter();
        r.additionalResults().put("priceCurve", this.prices);
    }
}

