/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import org.jquantlib.pricingengines.vanilla.finitedifferences.FDDividendEngineBase;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class FDDividendEngineMerton73
extends FDDividendEngineBase {
    public FDDividendEngineMerton73(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        super(process, timeSteps, gridPoints, timeDependent);
    }

    @Override
    protected void setGridLimits() {
        double paidDividends = 0.0;
        for (int i = 0; i < this.events.size(); ++i) {
            if (!(this.getDividendTime(i) >= 0.0)) continue;
            paidDividends += this.getDiscountedDividend(i);
        }
        super.setGridLimits(this.process.stateVariable().currentLink().value() - paidDividends, this.getResidualTime());
        this.ensureStrikeInGrid();
    }

    @Override
    protected void executeIntermediateStep(int step) {
        double scaleFactor = this.getDiscountedDividend(step) / this.center + 1.0;
        this.sMin *= scaleFactor;
        this.sMax *= scaleFactor;
        this.center *= scaleFactor;
        this.intrinsicValues.scaleGrid(scaleFactor);
        this.initializeInitialCondition();
        this.prices.scaleGrid(scaleFactor);
        this.initializeOperator();
        super.initializeModel();
        super.initializeStepCondition();
        this.stepCondition.applyTo(this.prices.values(), this.getDividendTime(step));
    }
}

