/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.hybrid;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.Callability;
import org.jquantlib.cashflow.Dividend;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.DiscretizedAsset;
import org.jquantlib.instruments.bonds.ConvertibleBondOption;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeGrid;
import org.jquantlib.util.Std;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class DiscretizedConvertible
extends DiscretizedAsset {
    protected Array conversionProbability;
    protected Array spreadAdjustedRate;
    protected Array dividendValues;
    private final ConvertibleBondOption.ArgumentsImpl arguments;
    private final GeneralizedBlackScholesProcess process;
    private final List<Double> stoppingTimes;
    private final List<Double> callabilityTimes;
    private final List<Double> couponTimes;
    private final List<Double> dividendTimes;

    public DiscretizedConvertible(ConvertibleBondOption.ArgumentsImpl arguments, GeneralizedBlackScholesProcess process, TimeGrid grid) {
        int i;
        this.arguments = arguments;
        this.process = process;
        this.dividendValues = new Array(this.arguments.dividends.size()).fill(0.0);
        Date settlementDate = this.process.riskFreeRate().currentLink().referenceDate();
        for (int i2 = 0; i2 < this.arguments.dividends.size(); ++i2) {
            if (!((Dividend)this.arguments.dividends.get(i2)).date().ge(settlementDate)) continue;
            double value = ((Dividend)this.arguments.dividends.get(i2)).amount() * this.process.riskFreeRate().currentLink().discount(((Dividend)this.arguments.dividends.get(i2)).date());
            this.dividendValues.set(i2, value);
        }
        DayCounter dayCounter = this.process.riskFreeRate().currentLink().dayCounter();
        Date bondSettlement = this.arguments.settlementDate;
        this.stoppingTimes = new ArrayList<Double>(this.arguments.exercise.dates().size());
        for (i = 0; i < this.arguments.exercise.dates().size(); ++i) {
            this.stoppingTimes.add(dayCounter.yearFraction(bondSettlement, this.arguments.exercise.date(i)));
        }
        this.callabilityTimes = new ArrayList<Double>(this.arguments.callabilityDates.size());
        for (i = 0; i < this.arguments.callabilityDates.size(); ++i) {
            this.callabilityTimes.add(dayCounter.yearFraction(bondSettlement, this.arguments.callabilityDates.get(i)));
        }
        this.couponTimes = new ArrayList<Double>(this.arguments.couponDates.size());
        for (i = 0; i < this.arguments.couponDates.size(); ++i) {
            this.couponTimes.add(dayCounter.yearFraction(bondSettlement, this.arguments.couponDates.get(i)));
        }
        this.dividendTimes = new ArrayList<Double>(this.arguments.dividendDates.size());
        for (i = 0; i < this.arguments.dividendDates.size(); ++i) {
            this.dividendTimes.add(dayCounter.yearFraction(bondSettlement, this.arguments.dividendDates.get(i)));
        }
        if (!grid.empty()) {
            for (i = 0; i < this.stoppingTimes.size(); ++i) {
                this.stoppingTimes.set(i, grid.closestTime(this.stoppingTimes.get(i)));
            }
            for (i = 0; i < this.couponTimes.size(); ++i) {
                this.couponTimes.set(i, grid.closestTime(this.couponTimes.get(i)));
            }
            for (i = 0; i < this.callabilityTimes.size(); ++i) {
                this.callabilityTimes.set(i, grid.closestTime(this.callabilityTimes.get(i)));
            }
            for (i = 0; i < this.dividendTimes.size(); ++i) {
                this.dividendTimes.set(i, grid.closestTime(this.dividendTimes.get(i)));
            }
        }
    }

    public final Array conversionProbability() {
        return this.conversionProbability;
    }

    public final Array spreadAdjustedRate() {
        return this.spreadAdjustedRate;
    }

    public final Array dividendValues() {
        return this.dividendValues;
    }

    public final void setConversionProbability(Array a) {
        this.conversionProbability = a;
    }

    public final void setSpreadAdjustedRate(Array a) {
        this.spreadAdjustedRate = a;
    }

    public final void setDividendValues(Array a) {
        this.dividendValues = a;
    }

    @Override
    public List<Double> mandatoryTimes() {
        ArrayList<Double> result = new ArrayList<Double>();
        Std.copy(this.stoppingTimes, 0, this.stoppingTimes.size(), result);
        Std.copy(this.callabilityTimes, 0, this.callabilityTimes.size(), result);
        Std.copy(this.couponTimes, 0, this.couponTimes.size(), result);
        return result;
    }

    public void applyConvertibility() {
        Array grid = this.adjustedGrid();
        for (int j = 0; j < this.values_.size(); ++j) {
            double payoff = this.arguments.conversionRatio * grid.get(j);
            if (!(this.values_.get(j) <= payoff)) continue;
            this.values_.set(j, payoff);
            this.conversionProbability.set(j, 1.0);
        }
    }

    public void applyCallability(int i, boolean convertible) {
        Array grid = this.adjustedGrid();
        Callability.Type Call = Callability.Type.Call;
        Callability.Type Put = Callability.Type.Put;
        switch (this.arguments.callabilityTypes.get(i)) {
            case Call: {
                if (this.arguments.callabilityTriggers.get(i) != Double.MAX_VALUE) {
                    double conversionValue = this.arguments.redemption / this.arguments.conversionRatio;
                    double trigger = conversionValue * this.arguments.callabilityTriggers.get(i);
                    for (int j = 0; j < this.values_.size(); ++j) {
                        if (!(grid.get(j) >= trigger)) continue;
                        this.values_.set(j, Math.min(Math.max(this.arguments.callabilityPrices.get(i), this.arguments.conversionRatio * grid.get(j)), this.values_.get(j)));
                    }
                } else if (convertible) {
                    for (int j = 0; j < this.values_.size(); ++j) {
                        this.values_.set(j, Math.min(Math.max(this.arguments.callabilityPrices.get(i), this.arguments.conversionRatio * grid.get(j)), this.values_.get(j)));
                    }
                } else {
                    for (int j = 0; j < this.values_.size(); ++j) {
                        this.values_.set(j, Math.min(this.arguments.callabilityPrices.get(j), this.values_.get(j)));
                    }
                }
                break;
            }
            case Put: {
                for (int j = 0; j < this.values_.size(); ++j) {
                    this.values_.set(j, Math.max(this.values_.get(j), this.arguments.callabilityPrices.get(i)));
                }
                break;
            }
            default: {
                QL.error("unknown callability type");
            }
        }
    }

    public void addCoupon(int i) {
        this.values_.addAssign(this.arguments.couponAmounts.get(i));
    }

    public Array adjustedGrid() {
        double t = this.time();
        Array grid = this.method().grid(t);
        for (int i = 0; i < this.arguments.dividends.size(); ++i) {
            double dividendTime = this.dividendTimes.get(i);
            if (!(dividendTime >= t) && !Closeness.isCloseEnough(dividendTime, t)) continue;
            Dividend d = (Dividend)this.arguments.dividends.get(i);
            for (int j = 0; j < grid.size(); ++j) {
                double v = grid.get(j);
                v += d.amount(v);
                grid.set(j, v);
            }
        }
        return grid;
    }

    @Override
    public void reset(int size) {
        this.values_ = new Array(size).fill(this.arguments.redemption);
        this.conversionProbability = new Array(size).fill(0.0);
        this.spreadAdjustedRate = new Array(size).fill(0.0);
        DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
        this.adjustValues();
        double creditSpread = this.arguments.creditSpread.currentLink().value();
        Date exercise = this.arguments.exercise.lastDate();
        double riskFreeRate = this.process.riskFreeRate().currentLink().zeroRate(exercise, rfdc, Compounding.Continuous, Frequency.NoFrequency).rate();
        for (int j = 0; j < this.values_.size(); ++j) {
            this.spreadAdjustedRate.set(j, this.conversionProbability.get(j) * riskFreeRate + (1.0 - this.conversionProbability.get(j)) * (riskFreeRate + creditSpread));
        }
    }

    @Override
    protected void postAdjustValuesImpl() {
        int i;
        Exercise.Type American = Exercise.Type.American;
        Exercise.Type European = Exercise.Type.European;
        Exercise.Type Bermudan = Exercise.Type.Bermudan;
        boolean convertible = false;
        switch (this.arguments.exercise.type()) {
            case American: {
                if (!(this.time() <= this.stoppingTimes.get(1)) || !(this.time() >= this.stoppingTimes.get(0))) break;
                convertible = true;
                break;
            }
            case European: {
                if (!this.isOnTime(this.stoppingTimes.get(0))) break;
                convertible = true;
                break;
            }
            case Bermudan: {
                for (i = 0; i < this.stoppingTimes.size(); ++i) {
                    if (!this.isOnTime(this.stoppingTimes.get(i))) continue;
                    convertible = true;
                }
                break;
            }
            default: {
                QL.error("invalid option type");
            }
        }
        for (i = 0; i < this.callabilityTimes.size(); ++i) {
            if (!this.isOnTime(this.callabilityTimes.get(i))) continue;
            this.applyCallability(i, convertible);
        }
        for (i = 0; i < this.couponTimes.size(); ++i) {
            if (!this.isOnTime(this.couponTimes.get(i))) continue;
            this.addCoupon(i);
        }
        if (convertible) {
            this.applyConvertibility();
        }
    }
}

