/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import org.jquantlib.QL;
import org.jquantlib.instruments.AssetOrNothingPayoff;
import org.jquantlib.instruments.CashOrNothingPayoff;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;

public class AmericanPayoffAtExpiry {
    private final double discount;
    private final double forward;
    private final double stdDev;
    private final double strike;
    private final double log_H_S;
    private final double cum_d1;
    private final double cum_d2;
    private final double n_d1;
    private final double n_d2;
    private final double alpha;
    private final double beta;
    private final double DalphaDd1;
    private final double DbetaDd2;
    private final boolean inTheMoney;
    private final double x;
    private final double y;
    private double mu;
    private double K;
    private double D1;
    private double D2;
    private double DKDstrike;
    private double DXDstrike;
    private double DYDstrike;

    public AmericanPayoffAtExpiry(double spot, double discount, double dividendDiscount, double variance, StrikedTypePayoff strikedTypePayoff) {
        QL.require(spot > 0.0, "positive spot value required");
        QL.require(discount > 0.0, "positive discount required");
        QL.require(dividendDiscount > 0.0, "positive dividend discount required");
        QL.require(variance >= 0.0, "non-negative variance required");
        this.discount = discount;
        this.forward = spot * dividendDiscount / discount;
        this.stdDev = Math.sqrt(variance);
        Option.Type optionType = strikedTypePayoff.optionType();
        this.strike = strikedTypePayoff.strike();
        this.mu = Math.log(dividendDiscount / discount) / variance - 0.5;
        if (strikedTypePayoff instanceof CashOrNothingPayoff) {
            CashOrNothingPayoff coo = (CashOrNothingPayoff)strikedTypePayoff;
            this.K = coo.getCashPayoff();
            this.DKDstrike = 0.0;
        } else if (strikedTypePayoff instanceof AssetOrNothingPayoff) {
            this.K = this.forward;
            this.DKDstrike = 0.0;
            this.mu += 1.0;
        }
        this.log_H_S = Math.log(this.strike / spot);
        if (variance >= Math.E) {
            this.D1 = this.log_H_S / this.stdDev + this.mu * this.stdDev;
            this.D2 = this.D1 - 2.0 * this.mu * this.stdDev;
            CumulativeNormalDistribution f = new CumulativeNormalDistribution();
            this.cum_d1 = f.op(this.D1);
            this.cum_d2 = f.op(this.D2);
            this.n_d1 = f.derivative(this.D1);
            this.n_d2 = f.derivative(this.D2);
        } else {
            if (this.log_H_S > 0.0) {
                this.cum_d1 = 1.0;
                this.cum_d2 = 1.0;
            } else {
                this.cum_d1 = 0.0;
                this.cum_d2 = 0.0;
            }
            this.n_d1 = 0.0;
            this.n_d2 = 0.0;
        }
        if (optionType.equals((Object)Option.Type.Call)) {
            if (this.strike > spot) {
                this.alpha = 1.0 - this.cum_d2;
                this.DalphaDd1 = -this.n_d2;
                this.beta = 1.0 - this.cum_d1;
                this.DbetaDd2 = -this.n_d1;
            } else {
                this.alpha = 0.5;
                this.DalphaDd1 = 0.0;
                this.beta = 0.5;
                this.DbetaDd2 = 0.0;
            }
        } else if (optionType.equals((Object)Option.Type.Put)) {
            if (this.strike < spot) {
                this.alpha = this.cum_d2;
                this.DalphaDd1 = this.n_d2;
                this.beta = this.cum_d1;
                this.DbetaDd2 = this.n_d1;
            } else {
                this.alpha = 0.5;
                this.DalphaDd1 = 0.0;
                this.beta = 0.5;
                this.DbetaDd2 = 0.0;
            }
        } else {
            throw new IllegalArgumentException("invalid option type");
        }
        boolean bl = this.inTheMoney = optionType.equals((Object)Option.Type.Call) && this.strike < spot || optionType.equals((Object)Option.Type.Put) && this.strike > spot;
        if (this.inTheMoney) {
            this.y = 1.0;
            this.x = 1.0;
            this.DYDstrike = 0.0;
            this.DXDstrike = 0.0;
        } else {
            this.y = 1.0;
            this.x = Math.pow(this.strike / spot, 2.0 * this.mu);
        }
    }

    public double value() {
        double result = this.discount * this.K * (this.y * this.alpha + this.x * this.beta);
        return result;
    }
}

