/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import java.util.Iterator;
import org.jquantlib.model.volatility.VolatilityCompositor;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeSeries;

public class ConstantEstimator
implements VolatilityCompositor {
    private final int size;

    public ConstantEstimator(int size) {
        this.size = size;
    }

    @Override
    public void calibrate(TimeSeries<Double> timeSeries) {
    }

    @Override
    public TimeSeries<Double> calculate(TimeSeries<Double> quotes) {
        TimeSeries<Double> retval = new TimeSeries<Double>(Double.class);
        Iterator it1 = quotes.navigableKeySet().iterator();
        double sumu2 = 0.0;
        double sumu = 0.0;
        Date d1 = null;
        for (int i = 0; i < this.size; ++i) {
            d1 = (Date)it1.next();
            double u = (Double)quotes.get(d1);
            sumu += u;
            sumu2 += u * u;
        }
        retval.put(d1, Math.sqrt(sumu2 / (double)this.size - sumu * sumu / (double)this.size / (double)(this.size + 1)));
        Iterator it2 = quotes.navigableKeySet().iterator();
        while (it1.hasNext()) {
            d1 = (Date)it1.next();
            double u = (Double)quotes.get(d1);
            sumu += u;
            sumu2 += u * u;
            Date d2 = (Date)it2.next();
            double v = (Double)quotes.get(d2);
            retval.put(d1, Math.sqrt((sumu2 -= v * v) / (double)this.size - (sumu -= v) * sumu / (double)this.size / (double)(this.size + 1)));
        }
        return retval;
    }
}

