/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.equity;

import org.jquantlib.math.optimization.NoConstraint;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;
import org.jquantlib.model.equity.HestonModel;
import org.jquantlib.processes.HestonProcess;

public class BatesModel
extends HestonModel {
    public BatesModel(HestonProcess process, double lambda, double nu, double delta) {
        super(process);
        this.arguments_.set(5, new ConstantParameter(nu, new NoConstraint()));
        this.arguments_.set(6, new ConstantParameter(delta, new PositiveConstraint()));
        this.arguments_.set(7, new ConstantParameter(lambda, new PositiveConstraint()));
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public BatesModel(HestonProcess process) {
        this(process, 0.1, 0.0, 0.1);
    }

    public double nu() {
        return ((Parameter)this.arguments_.get(5)).get(0.0);
    }

    public double delta() {
        return ((Parameter)this.arguments_.get(6)).get(0.0);
    }

    public double lambda() {
        return ((Parameter)this.arguments_.get(7)).get(0.0);
    }

    private static class BatesDetJumpModel
    extends BatesModel {
        public BatesDetJumpModel(HestonProcess process) {
            this(process, 0.1, 0.0, 0.1, 1.0, 0.1);
        }

        public BatesDetJumpModel(HestonProcess process, double lambda, double nu, double delta, double kappaLambda, double thetaLambda) {
            super(process);
            this.arguments_.set(8, new ConstantParameter(kappaLambda, new PositiveConstraint()));
            this.arguments_.set(9, new ConstantParameter(thetaLambda, new PositiveConstraint()));
        }

        public double kappaLambda() {
            return ((Parameter)this.arguments_.get(8)).get(0.0);
        }

        public double thethaLambda() {
            return ((Parameter)this.arguments_.get(9)).get(0.0);
        }
    }
}

