/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.instruments.DiscretizedAsset;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.lattices.BlackScholesLattice;
import org.jquantlib.methods.lattices.Tree;
import org.jquantlib.pricingengines.hybrid.DiscretizedConvertible;

public class TsiveriotisFernandesLattice<T extends Tree>
extends BlackScholesLattice<T> {
    private final double pd;
    private final double pu;
    private final double creditSpread;
    private final double dt;
    private final double riskFreeRate;

    public TsiveriotisFernandesLattice(T tree, double riskFreeRate, double end, int steps, double creditSpread, double sigma, double divYield) {
        super(tree, riskFreeRate, end, steps);
        this.dt = end / (double)steps;
        this.pd = ((Tree)tree).probability(0, 0, 0);
        this.pu = ((Tree)tree).probability(0, 0, 1);
        this.riskFreeRate = riskFreeRate;
        this.creditSpread = creditSpread;
        if (this.pu > 1.0) {
            throw new IllegalStateException("negative probability");
        }
        if (this.pu < 0.0) {
            throw new IllegalStateException("negative probability");
        }
    }

    public void stepback(int i, Array values, Array conversionProbability, Array spreadAdjustedRate, Array newValues, Array newConversionProbability, Array newSpreadAdjustedRate) {
        for (int j = 0; j < this.size(i); ++j) {
            newConversionProbability.set(j, this.pd * conversionProbability.get(j) + this.pu * conversionProbability.get(j + 1));
            newSpreadAdjustedRate.set(j, newConversionProbability.get(j) * this.riskFreeRate + (1.0 - newConversionProbability.get(j)) * (this.riskFreeRate + this.creditSpread));
            newValues.set(j, this.pd * values.get(j) / (1.0 + spreadAdjustedRate.get(j) * this.dt) + this.pu * values.get(j + 1) / (1.0 + spreadAdjustedRate.get(j + 1) * this.dt));
        }
    }

    @Override
    public void rollback(DiscretizedAsset asset, double to) {
        this.partialRollback(asset, to);
        asset.adjustValues();
    }

    @Override
    public void partialRollback(DiscretizedAsset asset, double to) {
        double from = asset.time();
        if (Closeness.isClose(from, to)) {
            return;
        }
        if (from <= to) {
            throw new IllegalStateException("cannot roll the asset back to " + to + " (it is already at t = " + from + ")");
        }
        DiscretizedConvertible convertible = (DiscretizedConvertible)asset;
        int iFrom = this.t.index(from);
        int iTo = this.t.index(to);
        for (int i = iFrom - 1; i >= iTo; --i) {
            Array newValues = new Array(this.size(i));
            Array newSpreadAdjustedRate = new Array(this.size(i));
            Array newConversionProbability = new Array(this.size(i));
            this.stepback(i, convertible.values(), convertible.conversionProbability(), convertible.spreadAdjustedRate(), newValues, newConversionProbability, newSpreadAdjustedRate);
            convertible.setTime(this.t.get(i));
            convertible.setValues(newValues);
            convertible.setSpreadAdjustedRate(newSpreadAdjustedRate);
            convertible.setConversionProbability(newConversionProbability);
            if (i == iTo) continue;
            convertible.adjustValues();
        }
    }
}

