/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Real;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.lang.annotation.Unused;
import org.jquantlib.methods.lattices.EqualJumpsBinomialTree;
import org.jquantlib.processes.StochasticProcess1D;

public class CoxRossRubinstein
extends EqualJumpsBinomialTree {
    public CoxRossRubinstein(StochasticProcess1D process, @Time double end, @NonNegative int steps, @Unused @Real double strike) {
        super(process, end, steps);
        this.dx = process.stdDeviation(0.0, this.x0, this.dt);
        this.pu = 0.5 + 0.5 * this.driftPerStep / this.dx;
        this.pd = 1.0 - this.pu;
        if (this.pu < 0.0 || this.pu > 1.0) {
            throw new IllegalStateException("negative probability");
        }
    }
}

