/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.BoundaryConditionSet;
import org.jquantlib.methods.finitedifferences.CrankNicolson;
import org.jquantlib.methods.finitedifferences.ParallelEvolver;
import org.jquantlib.methods.finitedifferences.StepConditionSet;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;

public class StandardSystemFiniteDifferenceModel {
    private final ParallelEvolver<TridiagonalOperator, CrankNicolson<TridiagonalOperator>> evolver;
    private final List<Double> stoppingTimes;

    public StandardSystemFiniteDifferenceModel(List<TridiagonalOperator> L, BoundaryConditionSet<BoundaryCondition<TridiagonalOperator>> bcs, List<Double> stoppingTimes) {
        this.evolver = new StandardSystemFiniteDifferenceModelParallelEvolver(L, bcs);
        HashSet<Double> times = new HashSet<Double>(stoppingTimes);
        this.stoppingTimes = new ArrayList<Double>(times);
        Collections.sort(stoppingTimes);
    }

    public StandardSystemFiniteDifferenceModel(List<TridiagonalOperator> L, BoundaryConditionSet<BoundaryCondition<TridiagonalOperator>> bcs) {
        this(L, bcs, new ArrayList<Double>());
    }

    public ParallelEvolver<TridiagonalOperator, CrankNicolson<TridiagonalOperator>> getEvolver() {
        return this.evolver;
    }

    public <V extends List<Array>> void rollback(V a, double from, double to, int steps) {
        this.rollbackImpl(a, from, to, steps, null);
    }

    public List<Array> rollback(List<Array> a, double from, double to, int steps, StepConditionSet<Array> condition) {
        return this.rollbackImpl(a, from, to, steps, condition);
    }

    private List<Array> rollbackImpl(List<Array> a, double from, double to, int steps, StepConditionSet<Array> condition) {
        if (from <= to) {
            throw new IllegalStateException("trying to roll back from " + from + " to " + to);
        }
        double dt = (from - to) / (double)steps;
        double t = from;
        this.evolver.setStep(dt);
        int i = 0;
        while (i < steps) {
            double now = t;
            double next = t - dt;
            boolean hit = false;
            for (int j = this.stoppingTimes.size() - 1; j >= 0; --j) {
                if (!(next <= this.stoppingTimes.get(j)) || !(this.stoppingTimes.get(j) < now)) continue;
                hit = true;
                this.evolver.setStep(now - this.stoppingTimes.get(j));
                a = this.evolver.step(a, now);
                if (condition != null) {
                    condition.applyTo(a, this.stoppingTimes.get(j));
                }
                now = this.stoppingTimes.get(j);
            }
            if (hit) {
                if (now > next) {
                    this.evolver.setStep(now - next);
                    a = this.evolver.step(a, now);
                    if (condition != null) {
                        condition.applyTo(a, next);
                    }
                }
                this.evolver.setStep(dt);
            } else {
                a = this.evolver.step(a, now);
                if (condition != null) {
                    condition.applyTo(a, next);
                }
            }
            ++i;
            t -= dt;
        }
        return a;
    }

    static class StandardSystemFiniteDifferenceModelParallelEvolver
    extends ParallelEvolver<TridiagonalOperator, CrankNicolson<TridiagonalOperator>> {
        public StandardSystemFiniteDifferenceModelParallelEvolver(List<TridiagonalOperator> L, BoundaryConditionSet<BoundaryCondition<TridiagonalOperator>> bcs) {
            super(TridiagonalOperator.class, CrankNicolson.class, L, bcs);
        }
    }
}

