/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.distributions.Derivative;
import org.jquantlib.math.solvers1D.NewtonSafe;

public class Newton
extends AbstractSolver1D<Derivative> {
    @Override
    protected double solveImpl(Derivative f, double xAccuracy) {
        double froot = f.op(this.root);
        double dfroot = f.derivative(this.root);
        ++this.evaluationNumber;
        while (this.evaluationNumber <= this.getMaxEvaluations()) {
            double dx = froot / dfroot;
            this.root -= dx;
            if ((this.xMin - this.root) * (this.root - this.xMax) < 0.0) {
                NewtonSafe s = new NewtonSafe();
                s.setMaxEvaluations(this.getMaxEvaluations() - this.evaluationNumber);
                return s.solve(f, xAccuracy, this.root + dx, this.xMin, this.xMax);
            }
            if (Math.abs(dx) < xAccuracy) {
                return this.root;
            }
            froot = f.op(this.root);
            dfroot = f.derivative(this.root);
            ++this.evaluationNumber;
        }
        throw new ArithmeticException("maximum number of function evaluations exceeded");
    }
}

