/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.Ops;

public class FalsePosition
extends AbstractSolver1D<Ops.DoubleOp> {
    @Override
    protected double solveImpl(Ops.DoubleOp f, double xAccuracy) {
        double fh;
        double xh;
        double fl;
        double xl;
        if (this.fxMin < 0.0) {
            xl = this.xMin;
            fl = this.fxMin;
            xh = this.xMax;
            fh = this.fxMax;
        } else {
            xl = this.xMax;
            fl = this.fxMax;
            xh = this.xMin;
            fh = this.fxMin;
        }
        double dx = xh - xl;
        while (this.evaluationNumber <= this.getMaxEvaluations()) {
            double del;
            this.root = xl + dx * fl / (fl - fh);
            double froot = f.op(this.root);
            ++this.evaluationNumber;
            if (froot < 0.0) {
                del = xl - this.root;
                xl = this.root;
                fl = froot;
            } else {
                del = xh - this.root;
                xh = this.root;
                fh = froot;
            }
            dx = xh - xl;
            if (!(Math.abs(del) < xAccuracy) && froot != 0.0) continue;
            return this.root;
        }
        throw new ArithmeticException("maximum number of function evaluations exceeded");
    }
}

