/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import org.jquantlib.math.randomnumbers.InverseCumulative;
import org.jquantlib.math.randomnumbers.UniformRandomSequenceGenerator;
import org.jquantlib.methods.montecarlo.Sample;

public class InverseCumulativeRsg<USG extends UniformRandomSequenceGenerator, IC extends InverseCumulative>
implements UniformRandomSequenceGenerator {
    private final int dimension;
    private final USG ursg;
    private Sample<double[]> sequence;
    private IC ic;
    private double weight;

    public InverseCumulativeRsg(USG ursg) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.ursg = ursg;
        this.dimension = this.ursg.dimension();
        this.weight = 1.0;
        this.sequence = new Sample<double[]>(new double[this.dimension], this.weight);
        this.ic = null;
    }

    public InverseCumulativeRsg(USG ursg, IC ic) {
        this(ursg);
        this.ic = ic;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public long[] nextInt32Sequence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sample<double[]> nextSequence() {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        Sample<double[]> sample = this.ursg.nextSequence();
        double[] v = sample.value();
        this.weight = sample.weight();
        double[] d = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            d[i] = this.ic.op(v[i]);
        }
        return new Sample<double[]>(d, this.weight);
    }

    @Override
    public final Sample<double[]> lastSequence() {
        return this.sequence;
    }
}

