/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.math.Constants;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.Problem;

public class Simplex
extends OptimizationMethod {
    private final double lambda_;
    private List<Array> vertices_;
    private Array values_;
    private Array sum_;

    public Simplex(double lambda) {
        this.lambda_ = lambda;
    }

    public double computeSimplexSize(List<Array> vertices) {
        Array center = new Array(vertices.get(0).size());
        for (int i = 0; i < vertices.size(); ++i) {
            center.addAssign(vertices.get(i));
        }
        center.mulAssign(1.0 / (double)vertices.size());
        double result = 0.0;
        for (int i = 0; i < vertices.size(); ++i) {
            Array temp = vertices.get(i).sub(center);
            result += Math.sqrt(temp.dotProduct(temp));
        }
        return result / (double)vertices.size();
    }

    public double extrapolate(Problem P, int iHighest, double factor) {
        Array pTry;
        do {
            int dimensions = this.values_.size() - 1;
            double factor1 = (1.0 - factor) / (double)dimensions;
            double factor2 = factor1 - factor;
            pTry = this.sum_.mul(factor1).sub(this.vertices_.get(iHighest).mul(factor2));
        } while (!P.constraint().test(pTry) && Math.abs(factor *= 0.5) > Constants.QL_EPSILON);
        if (Math.abs(factor) <= Constants.QL_EPSILON) {
            return this.values_.get(iHighest);
        }
        factor *= 2.0;
        double vTry = P.value(pTry);
        if (vTry < this.values_.get(iHighest)) {
            this.values_.set(iHighest, vTry);
            this.sum_.addAssign(pTry.sub(this.vertices_.get(iHighest)));
            this.vertices_.set(iHighest, pTry);
        }
        return vTry;
    }

    @Override
    public EndCriteria.Type minimize(Problem P, EndCriteria endCriteria) {
        int iLowest;
        double factor;
        int i;
        double xtol = endCriteria.getRootEpsilon();
        int maxStationaryStateIterations_ = endCriteria.getMaxStationaryStateIterations();
        EndCriteria.Type ecType = EndCriteria.Type.None;
        P.reset();
        Array x_ = P.currentValue();
        Integer iterationNumber_ = 0;
        int n = x_.size();
        this.vertices_ = new ArrayList<Array>(n + 1);
        for (i = 0; i <= n; ++i) {
            this.vertices_.add(new Array(x_));
        }
        for (i = 0; i < n; ++i) {
            Array direction = new Array(n);
            direction.set(i, 1.0);
            P.constraint().update(this.vertices_.get(i + 1), direction, this.lambda_);
        }
        this.values_ = new Array(n + 1);
        for (i = 0; i <= n; ++i) {
            this.values_.set(i, P.value(this.vertices_.get(i)));
        }
        do {
            int iNextHighest;
            int iHighest;
            this.sum_ = new Array(n);
            for (i = 0; i <= n; ++i) {
                this.sum_.addAssign(this.vertices_.get(i));
            }
            iLowest = 0;
            if (this.values_.get(0) < this.values_.get(1)) {
                iHighest = 1;
                iNextHighest = 0;
            } else {
                iHighest = 0;
                iNextHighest = 1;
            }
            for (int i2 = 1; i2 <= n; ++i2) {
                if (this.values_.get(i2) > this.values_.get(iHighest)) {
                    iNextHighest = iHighest;
                    iHighest = i2;
                } else if (this.values_.get(i2) > this.values_.get(iNextHighest) && i2 != iHighest) {
                    iNextHighest = i2;
                }
                if (!(this.values_.get(i2) < this.values_.get(iLowest))) continue;
                iLowest = i2;
            }
            double simplexSize = this.computeSimplexSize(this.vertices_);
            iterationNumber_ = iterationNumber_ + 1;
            if (simplexSize < xtol || endCriteria.checkMaxIterations(iterationNumber_, ecType)) {
                endCriteria.checkStationaryPoint(0.0, 0.0, maxStationaryStateIterations_, ecType);
                endCriteria.checkMaxIterations(iterationNumber_, ecType);
                x_ = this.vertices_.get(iLowest);
                double low = this.values_.get(iLowest);
                P.setFunctionValue(low);
                P.setCurrentValue(x_);
                return ecType;
            }
            factor = -1.0;
            double vTry = this.extrapolate(P, iHighest, factor);
            if (vTry <= this.values_.get(iLowest) && factor == -1.0) {
                factor = 2.0;
                this.extrapolate(P, iHighest, factor);
                continue;
            }
            if (!(Math.abs(factor) > Constants.QL_EPSILON) || !(vTry >= this.values_.get(iNextHighest))) continue;
            double vSave = this.values_.get(iHighest);
            factor = 0.5;
            vTry = this.extrapolate(P, iHighest, factor);
            if (!(vTry >= vSave) || !(Math.abs(factor) > Constants.QL_EPSILON)) continue;
            for (int i3 = 0; i3 <= n; ++i3) {
                if (i3 == iLowest) continue;
                this.vertices_.set(i3, this.vertices_.get(i3).add(this.vertices_.get(iLowest)).mul(0.5));
                this.values_.set(i3, P.value(this.vertices_.get(i3)));
            }
        } while (!(Math.abs(factor) <= Constants.QL_EPSILON));
        x_ = this.vertices_.get(iLowest);
        double low = this.values_.get(iLowest);
        P.setFunctionValue(low);
        P.setCurrentValue(x_);
        return EndCriteria.Type.StationaryFunctionValue;
    }
}

