/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.CostFunction;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Problem {
    protected CostFunction costFunction_;
    protected Constraint constraint_;
    protected Array currentValue_;
    protected double functionValue_;
    protected double squaredNorm_;
    protected int functionEvaluation_;
    protected int gradientEvaluation_;

    public Problem(CostFunction costFunction, Constraint constraint) {
        this(costFunction, constraint, new Array(0));
    }

    public Problem(CostFunction costFunction, Constraint constraint, Array initialValue) {
        this.costFunction_ = costFunction;
        this.constraint_ = constraint;
        this.currentValue_ = initialValue.clone();
    }

    public void reset() {
        this.functionEvaluation_ = 0;
        this.gradientEvaluation_ = 0;
        this.functionValue_ = Double.MAX_VALUE;
        this.squaredNorm_ = Double.MAX_VALUE;
    }

    public double value(Array x) {
        ++this.functionEvaluation_;
        return this.costFunction_.value(x);
    }

    public Array values(Array x) {
        ++this.functionEvaluation_;
        return this.costFunction_.values(x);
    }

    public void gradient(Array grad_f, Array x) {
        ++this.gradientEvaluation_;
        this.costFunction_.gradient(grad_f, x);
    }

    public double valueAndGradient(Array grad_f, Array x) {
        ++this.functionEvaluation_;
        ++this.gradientEvaluation_;
        return this.costFunction_.valueAndGradient(grad_f, x);
    }

    public Constraint constraint() {
        return this.constraint_;
    }

    public CostFunction costFunction() {
        return this.costFunction_;
    }

    public void setCurrentValue(Array currentValue) {
        this.currentValue_ = currentValue;
    }

    public final Array currentValue() {
        return this.currentValue_;
    }

    public void setFunctionValue(double functionValue) {
        this.functionValue_ = functionValue;
    }

    public double functionValue() {
        return this.functionValue_;
    }

    public void setGradientNormValue(double squaredNorm) {
        this.squaredNorm_ = squaredNorm;
    }

    public double gradientNormValue() {
        return this.squaredNorm_;
    }

    public int functionEvaluation() {
        return this.functionEvaluation_;
    }

    public int gradientEvaluation() {
        return this.gradientEvaluation_;
    }
}

