/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.ConjugateGradient;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.LeastSquareFunction;
import org.jquantlib.math.optimization.LeastSquareProblem;
import org.jquantlib.math.optimization.OptimizationMethod;
import org.jquantlib.math.optimization.Problem;

public class NonLinearLeastSquare {
    private Array results_;
    private Array initialValue_;
    private double resnorm_;
    private int exitFlag_ = -1;
    private double accuracy_;
    private double bestAccuracy_;
    private int maxIterations_;
    private int nbIterations_;
    private OptimizationMethod om_;
    private Constraint c_;

    public NonLinearLeastSquare(Constraint c, double accuracy, int maxiter) {
        this.accuracy_ = accuracy;
        this.maxIterations_ = maxiter;
        this.om_ = new ConjugateGradient(null);
        this.c_ = c;
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public NonLinearLeastSquare(Constraint c) {
        this(c, 1.0E-4, 100);
    }

    public NonLinearLeastSquare(Constraint c, double accuracy, int maxiter, OptimizationMethod om) {
        this.accuracy_ = accuracy;
        this.maxIterations_ = maxiter;
        this.om_ = om;
        this.c_ = c;
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public Array perform(LeastSquareProblem lsProblem) {
        double eps = this.accuracy_;
        LeastSquareFunction lsf = new LeastSquareFunction(lsProblem);
        Problem P = new Problem(lsf, this.c_, this.initialValue_);
        EndCriteria ec = new EndCriteria(this.maxIterations_, Math.min(this.maxIterations_ / 2, 100), eps, eps, eps);
        this.exitFlag_ = this.om_.minimize(P, ec).ordinal();
        this.results_ = P.currentValue();
        this.resnorm_ = P.functionValue();
        this.bestAccuracy_ = P.functionValue();
        return this.results_;
    }

    public void setInitialValue(Array initialValue) {
        this.initialValue_ = initialValue;
    }

    Array results() {
        return this.results_;
    }

    double residualNorm() {
        return this.resnorm_;
    }

    double lastValue() {
        return this.bestAccuracy_;
    }

    int exitFlag() {
        return this.exitFlag_;
    }

    Integer iterationsNumber() {
        return this.nbIterations_;
    }
}

