/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.SymmetricSchurDecomposition;

public class PseudoSqrt {
    private static final String unknown_salvaging_algorithm = "unknown salvaging algorithm";

    public Matrix pseudoSqrt(Matrix matrix) {
        return PseudoSqrt.pseudoSqrt(matrix, SalvagingAlgorithm.None);
    }

    public static Matrix rankReducedSqrt(Matrix matrix, int maxRank, int componentRetainedPercentage, SalvagingAlgorithm sa) {
        QL.validateExperimentalMode();
        QL.require(matrix.rows == matrix.columns(), "matrix must be square");
        QL.require(PseudoSqrt.checkSymmetry(matrix), "matrix must be symmetric");
        QL.require((double)componentRetainedPercentage > 0.0, "no eigenvalues retained");
        QL.require((double)componentRetainedPercentage <= 1.0, "percentage to be retained > 100%");
        QL.require(maxRank >= 1, "max rank required < 1");
        int size = matrix.rows;
        SymmetricSchurDecomposition jd = new SymmetricSchurDecomposition(matrix);
        Array eigenValues = jd.eigenvalues();
        switch (sa) {
            case None: {
                if (!(eigenValues.get(size - 1) < -1.0E-16)) break;
                throw new IllegalArgumentException("negative eigenvalue(s) (" + eigenValues.get(size - 1) + ")");
            }
            case Spectral: {
                for (int i = 0; i < size; ++i) {
                    eigenValues.set(i, Math.max(eigenValues.get(i), 0.0));
                }
                break;
            }
            case Higham: {
                int maxIterations = 40;
                double tolerance = 1.0E-6;
                Matrix adjustedMatrix = null;
                jd = new SymmetricSchurDecomposition(adjustedMatrix);
                eigenValues = jd.eigenvalues();
                break;
            }
            default: {
                throw new LibraryException("unknown or invalid salvaging algorithm");
            }
        }
        double enough = (double)componentRetainedPercentage * eigenValues.accumulate();
        if ((double)componentRetainedPercentage == 1.0) {
            enough *= 1.1;
        }
        double components = eigenValues.first();
        int retainedFactors = 1;
        for (int i = 1; components < enough && i < size; ++i) {
            components += eigenValues.get(i);
            ++retainedFactors;
        }
        retainedFactors = Math.min(retainedFactors, maxRank);
        Matrix diagonal = new Matrix(size, retainedFactors);
        for (int i = 0; i < retainedFactors; ++i) {
            diagonal.set(i, i, Math.sqrt(eigenValues.get(i)));
        }
        Matrix result = jd.eigenvectors().mul(jd.eigenvectors()).mul(diagonal);
        PseudoSqrt.normalizePseudoRoot(matrix, result);
        return result;
    }

    public static void normalizePseudoRoot(Matrix matrix, Matrix pseudo) {
        QL.validateExperimentalMode();
        int size = matrix.rows;
        if (size != pseudo.rows) {
            throw new IllegalArgumentException("matrix/pseudo mismatch: matrix rows are " + size + " while pseudo rows are " + pseudo.cols);
        }
        int pseudoCols = pseudo.cols;
        for (int i = 0; i < size; ++i) {
            double norm = 0.0;
            for (int j = 0; j < pseudoCols; ++j) {
                norm += pseudo.get(i, j) * pseudo.get(j, i);
            }
            if (!(norm > 0.0)) continue;
            double normAdj = Math.sqrt(matrix.get(i, i) / norm);
            for (int j = 0; j < pseudoCols; ++j) {
                pseudo.set(i, j, pseudo.get(i, j) * normAdj);
            }
        }
    }

    public static Matrix pseudoSqrt(Matrix matrix, SalvagingAlgorithm sa) {
        Matrix result;
        QL.validateExperimentalMode();
        QL.require(matrix.rows() == matrix.columns(), "matrix must be square");
        QL.require(PseudoSqrt.checkSymmetry(matrix), "matrix must be symmetric");
        int size = matrix.rows;
        SymmetricSchurDecomposition jd = new SymmetricSchurDecomposition(matrix);
        Matrix diagonal = new Matrix(size, size);
        switch (sa) {
            case None: {
                if (jd.eigenvalues().get(size - 1) < -1.0E-16) {
                    throw new IllegalArgumentException("negative eigenvalue(s) (" + jd.eigenvalues().get(size - 1) + ")");
                }
                result = matrix.cholesky().L();
                break;
            }
            case Spectral: {
                for (int i = 0; i < size; ++i) {
                    diagonal.set(i, i, Math.sqrt(Math.max(jd.eigenvalues().get(i), 0.0)));
                }
                throw new UnsupportedOperationException("work in progress");
            }
            case Hypersphere: {
                boolean negative = false;
                for (int i = 0; i < size; ++i) {
                    diagonal.set(i, i, Math.sqrt(Math.max(jd.eigenvalues().get(i), 0.0)));
                    if (!(jd.eigenvalues().get(i) < 0.0)) continue;
                    negative = true;
                }
                throw new UnsupportedOperationException("work in progress");
            }
            case LowerDiagonal: {
                boolean negative = false;
                for (int i = 0; i < size; ++i) {
                    diagonal.set(i, i, Math.sqrt(Math.max(jd.eigenvalues().get(i), 0.0)));
                    if (!(jd.eigenvalues().get(i) < 0.0)) continue;
                    negative = true;
                }
                throw new UnsupportedOperationException("work in progress");
            }
            case Higham: {
                int maxIterations = 40;
                double tol = 1.0E-6;
                throw new UnsupportedOperationException("work in progress");
            }
            default: {
                throw new LibraryException(unknown_salvaging_algorithm);
            }
        }
        return result;
    }

    private static boolean checkSymmetry(Matrix matrix) {
        int size = matrix.rows;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!Closeness.isClose(matrix.get(i, j), matrix.get(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    public static enum SalvagingAlgorithm {
        None,
        Spectral,
        Hypersphere,
        LowerDiagonal,
        Higham;

    }
}

