/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.internal.Address;

@QualityAssurance(quality=QualityAssurance.Quality.Q1_TRANSLATION, version=QualityAssurance.Version.OTHER, reviewers={"Richard Gomes"})
public class LUDecomposition {
    private static final String MATRIX_IS_SINGULAR = "Matrix is singular";
    private final int m;
    private final int n;
    private final Matrix LU;
    private final int[] piv;
    private int pivsign;

    public LUDecomposition(Matrix A) {
        this.LU = A.clone().toJava();
        this.m = this.LU.rows();
        this.n = this.LU.cols();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m; ++i2) {
                LUcolj[i2] = this.LU.$[((Address.MatrixAddress)this.LU.addr).op(i2, j)];
            }
            for (i2 = 0; i2 < this.m; ++i2) {
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += this.LU.$[((Address.MatrixAddress)this.LU.addr).op(i2, k)] * LUcolj[k];
                }
                int n = i2;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                this.LU.$[((Address.MatrixAddress)this.LU.addr).op((int)i2, (int)j)] = d;
            }
            int p = j;
            for (i = j + 1; i < this.m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.n; ++k) {
                    double t = this.LU.$[((Address.MatrixAddress)this.LU.addr).op(p, k)];
                    this.LU.$[((Address.MatrixAddress)this.LU.addr).op((int)p, (int)k)] = this.LU.$[((Address.MatrixAddress)this.LU.addr).op(j, k)];
                    this.LU.$[((Address.MatrixAddress)this.LU.addr).op((int)j, (int)k)] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j >= this.m || this.LU.$[((Address.MatrixAddress)this.LU.addr).op(j, j)] == 0.0) continue;
            for (i = j + 1; i < this.m; ++i) {
                int n = ((Address.MatrixAddress)this.LU.addr).op(i, j);
                this.LU.$[n] = this.LU.$[n] / this.LU.$[((Address.MatrixAddress)this.LU.addr).op(j, j)];
            }
        }
    }

    public boolean isNonSingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU.$[((Address.MatrixAddress)this.LU.addr).op(j, j)] != 0.0) continue;
            return false;
        }
        return true;
    }

    public Matrix L() {
        Matrix L = new Matrix(this.m, this.n);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i > j) {
                    L.$[((Address.MatrixAddress)L.addr).op((int)i, (int)j)] = this.LU.$[((Address.MatrixAddress)this.LU.addr).op(i, j)];
                    continue;
                }
                if (i != j) continue;
                L.$[((Address.MatrixAddress)L.addr).op((int)i, (int)j)] = 1.0;
            }
        }
        return L;
    }

    public Matrix U() {
        Matrix U = new Matrix(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i > j) continue;
                U.$[((Address.MatrixAddress)U.addr).op((int)i, (int)j)] = this.LU.$[((Address.MatrixAddress)this.LU.addr).op(i, j)];
            }
        }
        return U;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            p[i] = this.piv[i];
        }
        return p;
    }

    public double det() {
        QL.require(this.m == this.n, "matrix must be square");
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU.$[((Address.MatrixAddress)this.LU.addr).op(j, j)];
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i;
        int k;
        QL.require(B.rows() == this.m, "matrix is incompatible");
        if (!this.isNonSingular()) {
            throw new LibraryException(MATRIX_IS_SINGULAR);
        }
        Matrix X = B.range(this.piv, 0, B.cols());
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                for (j = 0; j < B.cols(); ++j) {
                    int n = ((Address.MatrixAddress)X.addr).op(i, j);
                    X.$[n] = X.$[n] - X.$[((Address.MatrixAddress)X.addr).op(k, j)] * this.LU.$[((Address.MatrixAddress)this.LU.addr).op(i, k)];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            for (int j2 = 0; j2 < B.cols(); ++j2) {
                int n = ((Address.MatrixAddress)X.addr).op(k, j2);
                X.$[n] = X.$[n] / this.LU.$[((Address.MatrixAddress)this.LU.addr).op(k, k)];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < B.cols(); ++j) {
                    int n = ((Address.MatrixAddress)X.addr).op(i, j);
                    X.$[n] = X.$[n] - X.$[((Address.MatrixAddress)X.addr).op(k, j)] * this.LU.$[((Address.MatrixAddress)this.LU.addr).op(i, k)];
                }
            }
        }
        return X;
    }
}

