/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.math.interpolations.AbstractInterpolation2D;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;

public class BilinearInterpolation
extends AbstractInterpolation2D {
    public BilinearInterpolation(Array vx, Array vy, Matrix mz) {
        this.impl_ = new BilinearInterpolationImpl(vx, vy, mz);
    }

    private class BilinearInterpolationImpl
    extends AbstractInterpolation2D.Impl {
        public BilinearInterpolationImpl(Array vx, Array vy, Matrix mz) {
            super(vx, vy, mz);
            this.calculate();
        }

        @Override
        public void calculate() {
        }

        @Override
        public double op(double x, double y) {
            int i = this.locateX(x);
            int j = this.locateY(y);
            double z1 = this.mz.get(j, i);
            double z2 = this.mz.get(j, i + 1);
            double z3 = this.mz.get(j + 1, i);
            double z4 = this.mz.get(j + 1, i + 1);
            double t = (x - this.vx.get(i)) / (this.vx.get(i + 1) - this.vx.get(i));
            double u = (y - this.vy.get(j)) / (this.vy.get(j + 1) - this.vy.get(j));
            return (1.0 - t) * (1.0 - u) * z1 + t * (1.0 - u) * z2 + (1.0 - t) * u * z3 + t * u * z4;
        }
    }
}

