/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.Factorial;
import org.jquantlib.math.Ops;

public class BinomialDistribution
implements Ops.IntToDouble {
    private static final String INVALID_PROBABILITY = "probability must be 0.0 <= p <= 1.0";
    private static final Factorial factorial = new Factorial();
    private final int nExp;
    private double logP;
    private double logOneMinusP;

    public BinomialDistribution(double p, int n) {
        QL.require(p >= 0.0 && p <= 1.0, INVALID_PROBABILITY);
        this.nExp = n;
        if (p == 0.0) {
            this.logOneMinusP = 0.0;
        } else if (p == 1.0) {
            this.logP = 0.0;
        } else {
            this.logP = Math.log(p);
            this.logOneMinusP = Math.log(1.0 - p);
        }
    }

    @Override
    public double op(int k) {
        if (k > this.nExp) {
            return 0.0;
        }
        if (this.logP == 0.0) {
            return k == this.nExp ? 1.0 : 0.0;
        }
        if (this.logOneMinusP == 0.0) {
            return k == 0 ? 1.0 : 0.0;
        }
        return Math.exp(this.binomialCoefficientLn(this.nExp, k) + (double)k * this.logP + (double)(this.nExp - k) * this.logOneMinusP);
    }

    private double binomialCoefficientLn(int n, int k) {
        QL.require(n >= 0, "n < 0 not allowed");
        QL.require(k >= 0, "k < 0 not allowed");
        QL.require(n >= k, "n < k not allowed");
        return factorial.ln(n) - factorial.ln(k) - factorial.ln(n - k);
    }

    private double binomialCoefficient(int n, int k) {
        return Math.floor(0.5 + Math.exp(this.binomialCoefficientLn(n, k)));
    }

    public static double PeizerPrattMethod2Inversion(double z, long n) {
        QL.require(n % 2L == 1L, "n must be an odd number");
        double result = z / ((double)n + 0.3333333333333333 + 0.1 / ((double)n + 1.0));
        result *= result;
        result = Math.exp(-result * ((double)n + 0.16666666666666666));
        result = 0.5 + (double)(z > 0.0 ? 1 : -1) * Math.sqrt(0.25 * (1.0 - result));
        return result;
    }
}

