/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.legacy.libormarkets;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.model.Parameter;

public abstract class LmVolatilityModel {
    private static final String integrated_variance_not_supported = "integratedVariance() method is not supported";
    protected final int size_;
    protected List<Parameter> arguments_;

    public LmVolatilityModel(int size, int nArguments) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.size_ = size;
        this.arguments_ = new ArrayList<Parameter>(nArguments);
    }

    public int size() {
        return this.size_;
    }

    public boolean isTimeIndependent() {
        return false;
    }

    public double volatility(int i, double t) {
        return this.volatility(t, new Array(i)).get(i);
    }

    public double volatility(int i, double t, Array x) {
        return this.volatility(t, x).get(i);
    }

    public Array volatility(double t) {
        return this.volatility(t, new Array(0));
    }

    public abstract Array volatility(double var1, Array var3);

    public double integratedVariance(int i, int ii, double t, Array list) {
        throw new LibraryException(integrated_variance_not_supported);
    }

    public void setParams(List<Parameter> arguments) {
        this.arguments_ = arguments;
        this.generateArguments();
    }

    protected abstract void generateArguments();
}

