/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments.bonds;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.Callability;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.Dividend;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.CallabilitySchedule;
import org.jquantlib.instruments.DividendSchedule;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.bonds.ConvertibleBond;
import org.jquantlib.instruments.bonds.SoftCallability;
import org.jquantlib.pricingengines.GenericEngine;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class ConvertibleBondOption
extends OneAssetOption {
    private final ConvertibleBond bond_;
    private final double conversionRatio_;
    private final CallabilitySchedule callability_;
    private final DividendSchedule dividends_;
    private final Handle<Quote> creditSpread_;
    private final Leg cashflows_;
    private final DayCounter dayCounter_;
    private final Date issueDate_;
    private final Schedule schedule_;
    private final int settlementDays_;
    private final double redemption_;

    public ConvertibleBondOption(ConvertibleBond bond, Exercise exercise, double conversionRatio, DividendSchedule dividends, CallabilitySchedule callability, Handle<Quote> creditSpread, Leg cashflows, DayCounter dayCounter, Schedule schedule, Date issueDate, int settlementDays, double redemption) {
        super(new PlainVanillaPayoff(Option.Type.Call, bond.faceAmount() / 100.0 * redemption / conversionRatio), exercise);
        this.bond_ = bond;
        this.conversionRatio_ = conversionRatio;
        this.callability_ = callability;
        this.dividends_ = dividends;
        this.creditSpread_ = creditSpread;
        this.cashflows_ = cashflows;
        this.dayCounter_ = dayCounter;
        this.issueDate_ = issueDate;
        this.schedule_ = schedule;
        this.settlementDays_ = settlementDays;
        this.redemption_ = redemption;
    }

    @Override
    public void setupArguments(PricingEngine.Arguments args) {
        int i;
        super.setupArguments(args);
        QL.require(ArgumentsImpl.class.isAssignableFrom(args.getClass()), "Unexpected type for type parameter");
        ArgumentsImpl moreArgs = args instanceof ArgumentsImpl ? (ArgumentsImpl)args : null;
        QL.require(moreArgs != null, "wrong argument type");
        moreArgs.conversionRatio = this.conversionRatio_;
        Date settlement = this.bond_.settlementDate().clone();
        int n = this.callability_.size();
        moreArgs.callabilityDates.clear();
        moreArgs.callabilityTypes.clear();
        moreArgs.callabilityPrices.clear();
        moreArgs.callabilityTriggers.clear();
        for (int i2 = 0; i2 < n; ++i2) {
            Object obj;
            SoftCallability softCall;
            if (((Callability)this.callability_.get(i2)).hasOccurred(settlement)) continue;
            moreArgs.callabilityTypes.add(((Callability)this.callability_.get(i2)).type());
            moreArgs.callabilityDates.add(((Callability)this.callability_.get(i2)).date());
            moreArgs.callabilityPrices.add(((Callability)this.callability_.get(i2)).price().amount());
            if (((Callability)this.callability_.get(i2)).price().type() == Callability.Price.Type.Clean) {
                int lastIdx = moreArgs.callabilityPrices.size() - 1;
                double d = moreArgs.callabilityPrices.get(lastIdx) + this.bond_.accruedAmount(((Callability)this.callability_.get(i2)).date());
                moreArgs.callabilityPrices.set(lastIdx, d);
            }
            SoftCallability softCallability = softCall = (obj = this.callability_.get(i2)) instanceof SoftCallability ? (SoftCallability)obj : null;
            if (softCall != null) {
                moreArgs.callabilityTriggers.add(softCall.trigger());
                continue;
            }
            moreArgs.callabilityTriggers.add((Double)Double.MAX_VALUE);
        }
        Leg cashflows = this.bond_.cashflows();
        moreArgs.couponDates.clear();
        moreArgs.couponAmounts.clear();
        for (i = 0; i < cashflows.size() - 1; ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(settlement)) continue;
            moreArgs.couponDates.add(((CashFlow)cashflows.get(i)).date());
            moreArgs.couponAmounts.add(((CashFlow)cashflows.get(i)).amount());
        }
        moreArgs.dividends.clear();
        moreArgs.dividendDates.clear();
        for (i = 0; i < this.dividends_.size(); ++i) {
            if (((Dividend)this.dividends_.get(i)).hasOccurred(settlement)) continue;
            moreArgs.dividends.add(this.dividends_.get(i));
            moreArgs.dividendDates.add(((Dividend)this.dividends_.get(i)).date());
        }
        moreArgs.creditSpread = this.creditSpread_;
        moreArgs.issueDate = this.issueDate_.clone();
        moreArgs.settlementDate = settlement.clone();
        moreArgs.settlementDays = this.settlementDays_;
        moreArgs.redemption = this.redemption_;
    }

    public static abstract class EngineImpl
    extends GenericEngine<ArgumentsImpl, ResultsImpl> {
        protected EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
        }
    }

    public static class ResultsImpl
    extends OneAssetOption.ResultsImpl {
        @Override
        public void reset() {
            super.reset();
        }
    }

    public static class ArgumentsImpl
    extends OneAssetOption.ArgumentsImpl
    implements Arguments {
        public double conversionRatio = Double.MAX_VALUE;
        public Handle<Quote> creditSpread;
        public DividendSchedule dividends;
        public List<Date> dividendDates;
        public List<Date> callabilityDates;
        public List<Callability.Type> callabilityTypes;
        public List<Double> callabilityPrices;
        public List<Double> callabilityTriggers;
        public List<Date> couponDates;
        public List<Double> couponAmounts;
        public Date issueDate;
        public Date settlementDate;
        public int settlementDays = Integer.MAX_VALUE;
        public double redemption = Double.MAX_VALUE;

        public ArgumentsImpl() {
            this.dividends = new DividendSchedule();
            this.dividendDates = new ArrayList<Date>();
            this.callabilityDates = new ArrayList<Date>();
            this.callabilityTypes = new ArrayList<Callability.Type>();
            this.callabilityPrices = new ArrayList<Double>();
            this.callabilityTriggers = new ArrayList<Double>();
            this.couponDates = new ArrayList<Date>();
            this.couponAmounts = new ArrayList<Double>();
        }

        @Override
        public void validate() {
            super.validate();
            QL.require(!Double.isNaN(this.conversionRatio), "null conversion ratio");
            QL.require(this.conversionRatio > 0.0, "positive conversion ratio required");
            QL.require(!Double.isNaN(this.redemption), "null redemption");
            QL.require(this.redemption >= 0.0, "positive redemption required");
            QL.require(!this.settlementDate.isNull(), "null settlement date");
            QL.require(this.settlementDays != Integer.MAX_VALUE, "null settlement days");
            QL.require(this.callabilityDates.size() == this.callabilityTypes.size(), "different number of callability dates and types");
            QL.require(this.callabilityDates.size() == this.callabilityPrices.size(), "different number of callability dates and prices");
            QL.require(this.callabilityDates.size() == this.callabilityTriggers.size(), "different number of callability dates and triggers");
            QL.require(this.couponDates.size() == this.couponAmounts.size(), "different number of coupon dates and amounts");
        }
    }

    public static interface Results
    extends Instrument.Results,
    Option.Greeks,
    Option.MoreGreeks {
    }

    public static interface Arguments
    extends OneAssetOption.Arguments {
    }
}

