/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.FixedRateCoupon;
import org.jquantlib.cashflow.FixedRateLeg;
import org.jquantlib.cashflow.IborCoupon;
import org.jquantlib.cashflow.IborLeg;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.instruments.Swap;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class VanillaSwap
extends Swap {
    static final double basisPoint = 1.0E-4;
    private final Type type;
    private final double nominal;
    private final Schedule fixedSchedule;
    private final double fixedRate;
    private final DayCounter fixedDayCount;
    private final Schedule floatingSchedule;
    private final IborIndex iborIndex;
    private final double spread;
    private final DayCounter floatingDayCount;
    private final BusinessDayConvention paymentConvention;
    private double fairRate;
    private double fairSpread;

    public VanillaSwap(Type type, double nominal, Schedule fixedSchedule, double fixedRate, DayCounter fixedDayCount, Schedule floatSchedule, IborIndex iborIndex, double spread, DayCounter floatingDayCount) {
        this(type, nominal, fixedSchedule, fixedRate, fixedDayCount, floatSchedule, iborIndex, spread, floatingDayCount, BusinessDayConvention.Following);
    }

    public VanillaSwap(Type type, double nominal, Schedule fixedSchedule, double fixedRate, DayCounter fixedDayCount, Schedule floatSchedule, IborIndex iborIndex, double spread, DayCounter floatingDayCount, BusinessDayConvention paymentConvention) {
        super(2);
        this.type = type;
        this.nominal = nominal;
        this.fixedSchedule = fixedSchedule;
        this.fixedRate = fixedRate;
        this.fixedDayCount = fixedDayCount;
        this.floatingSchedule = floatSchedule;
        this.iborIndex = iborIndex;
        this.spread = spread;
        this.floatingDayCount = floatingDayCount;
        this.paymentConvention = paymentConvention;
        Leg fixedLeg = new FixedRateLeg(fixedSchedule, fixedDayCount).withNotionals(nominal).withCouponRates(fixedRate).withPaymentAdjustment(paymentConvention).Leg();
        Leg floatingLeg = new IborLeg(this.floatingSchedule, iborIndex).withNotionals(nominal).withPaymentDayCounter(floatingDayCount).withPaymentAdjustment(paymentConvention).withSpreads(spread).Leg();
        for (CashFlow item : floatingLeg) {
            item.addObserver(this);
        }
        this.legs.add(fixedLeg);
        this.legs.add(floatingLeg);
        if (type == Type.Payer) {
            this.payer[0] = -1.0;
            this.payer[1] = 1.0;
        } else {
            this.payer[0] = 1.0;
            this.payer[1] = -1.0;
        }
    }

    public double fairRate() {
        this.calculate();
        QL.require(!Double.isNaN(this.fairRate), "result not available");
        return this.fairRate;
    }

    public double fairSpread() {
        this.calculate();
        QL.require(!Double.isNaN(this.fairSpread), "result not available");
        return this.fairSpread;
    }

    public final Leg fixedLeg() {
        return (Leg)this.legs.get(0);
    }

    public final Leg floatingLeg() {
        return (Leg)this.legs.get(1);
    }

    public double fixedLegBPS() {
        this.calculate();
        QL.require(!Double.isNaN(this.legBPS[0]), "result not available");
        return this.legBPS[0];
    }

    public double floatingLegBPS() {
        this.calculate();
        QL.require(!Double.isNaN(this.legBPS[1]), "result not available");
        return this.legBPS[1];
    }

    public double fixedLegNPV() {
        this.calculate();
        QL.require(!Double.isNaN(this.legNPV[0]), "result not available");
        return this.legNPV[0];
    }

    public double floatingLegNPV() {
        this.calculate();
        QL.require(!Double.isNaN(this.legNPV[1]), "result not available");
        return this.legNPV[1];
    }

    @Override
    public void setupExpired() {
        super.setupExpired();
        this.legBPS[0] = 0.0;
        this.legBPS[1] = 0.0;
        this.fairRate = Double.MAX_VALUE;
        this.fairSpread = Double.MAX_VALUE;
    }

    @Override
    public void setupArguments(PricingEngine.Arguments arguments) {
        super.setupArguments(arguments);
        if (arguments.getClass().isAssignableFrom(Arguments.class)) {
            ArgumentsImpl a = (ArgumentsImpl)arguments;
            a.type = this.type;
            a.nominal = this.nominal;
            Leg fixedCoupons = this.fixedLeg();
            a.fixedResetDates = new ArrayList<Date>(fixedCoupons.size());
            a.fixedPayDates = new ArrayList<Date>(fixedCoupons.size());
            a.fixedCoupons = new ArrayList<Double>(fixedCoupons.size());
            for (int i = 0; i < fixedCoupons.size(); ++i) {
                FixedRateCoupon coupon = (FixedRateCoupon)fixedCoupons.get(i);
                a.fixedPayDates.set(i, coupon.date());
                a.fixedResetDates.set(i, coupon.accrualStartDate());
                a.fixedCoupons.set(i, coupon.amount());
            }
            Leg floatingCoupons = this.floatingLeg();
            a.floatingResetDates = new ArrayList<Date>(floatingCoupons.size());
            a.floatingPayDates = new ArrayList<Date>(floatingCoupons.size());
            a.floatingFixingDates = new ArrayList<Date>(floatingCoupons.size());
            a.floatingAccrualTimes = new ArrayList<Double>(floatingCoupons.size());
            a.floatingSpreads = new ArrayList<Double>(floatingCoupons.size());
            a.floatingCoupons = new ArrayList<Double>(floatingCoupons.size());
            for (int i = 0; i < floatingCoupons.size(); ++i) {
                IborCoupon coupon = (IborCoupon)floatingCoupons.get(i);
                a.floatingResetDates.set(i, coupon.accrualStartDate());
                a.floatingPayDates.set(i, coupon.date());
                a.floatingFixingDates.set(i, coupon.fixingDate());
                a.floatingAccrualTimes.set(i, coupon.accrualPeriod());
                a.floatingSpreads.set(i, coupon.spread());
                try {
                    a.floatingCoupons.set(i, coupon.amount());
                    continue;
                }
                catch (Exception e) {
                    a.floatingCoupons.set(i, (Double)Double.MAX_VALUE);
                }
            }
        }
    }

    @Override
    public void fetchResults(PricingEngine.Results results) {
        super.fetchResults(results);
        if (results.getClass().isAssignableFrom(Results.class)) {
            ResultsImpl r = (ResultsImpl)results;
            this.fairRate = r.fairRate;
            this.fairSpread = r.fairSpread;
        } else {
            this.fairRate = Double.MAX_VALUE;
            this.fairSpread = Double.MAX_VALUE;
        }
        if (Double.isNaN(this.fairRate) && !Double.isNaN(this.legBPS[0])) {
            this.fairRate = this.fixedRate - this.NPV / (this.legBPS[0] / 1.0E-4);
        }
        if (Double.isNaN(this.fairSpread) && !Double.isNaN(this.legBPS[1])) {
            this.fairSpread = this.spread - this.NPV / (this.legBPS[1] / 1.0E-4);
        }
    }

    public String toString() {
        return this.type.toString();
    }

    public class ResultsImpl
    extends Swap.ResultsImpl
    implements Results {
        public double fairRate;
        public double fairSpread;

        @Override
        public void reset() {
            super.reset();
            this.fairRate = Double.MAX_VALUE;
            this.fairSpread = Double.MAX_VALUE;
        }
    }

    public class ArgumentsImpl
    extends Swap.ArgumentsImpl
    implements Arguments {
        public Type type;
        public double nominal;
        public List<Date> fixedResetDates;
        public List<Date> fixedPayDates;
        public List<Double> floatingAccrualTimes;
        public List<Date> floatingResetDates;
        public List<Date> floatingFixingDates;
        public List<Date> floatingPayDates;
        public List<Double> fixedCoupons;
        public List<Double> floatingSpreads;
        public List<Double> floatingCoupons;

        @Override
        public void validate() {
            super.validate();
            QL.require(!Double.isNaN(this.nominal), "nominal null or not set");
            QL.require(this.fixedResetDates.size() == this.fixedPayDates.size(), "number of fixed start dates different from number of fixed payment dates");
            QL.require(this.fixedPayDates.size() == this.fixedCoupons.size(), "number of fixed payment dates different from number of fixed coupon amounts");
            QL.require(this.floatingResetDates.size() == this.floatingPayDates.size(), "number of floating start dates different from number of floating payment dates");
            QL.require(this.floatingFixingDates.size() == this.floatingPayDates.size(), "number of floating fixing dates different from number of floating payment dates");
            QL.require(this.floatingAccrualTimes.size() == this.floatingPayDates.size(), "number of floating accrual Times different from number of floating payment dates");
            QL.require(this.floatingSpreads.size() == this.floatingPayDates.size(), "number of floating spreads different from number of floating payment dates");
            QL.require(this.floatingPayDates.size() == this.floatingCoupons.size(), "number of floating payment dates different from number of floating coupon amounts");
        }
    }

    public static interface Results
    extends Swap.Results {
    }

    public static interface Arguments
    extends Swap.Arguments {
    }

    public static enum Type {
        Receiver(-1),
        Payer(1);

        private final int enumValue;

        private Type(int frequency) {
            this.enumValue = frequency;
        }

        public static Type valueOf(int value) {
            switch (value) {
                case -1: {
                    return Receiver;
                }
                case 1: {
                    return Payer;
                }
            }
            throw new LibraryException("value must be one of -1, 1");
        }

        public int toInteger() {
            return this.enumValue;
        }
    }
}

