/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.ImpliedVolatilityHelper;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.AnalyticEuropeanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDAmericanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDBermudanEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.quotes.SimpleQuote;

public class VanillaOption
extends OneAssetOption {
    private static final String UNKNOWN_EXERCISE_TYPE = "unknown exercise type";

    public VanillaOption(Payoff payoff, Exercise exercise) {
        super(payoff, exercise);
    }

    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process) {
        return this.impliedVolatility(price, process, 1.0E-4, 100, 1.0E-7, 4.0);
    }

    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process, double accuracy) {
        return this.impliedVolatility(price, process, accuracy, 100, 1.0E-7, 4.0);
    }

    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process, double accuracy, int maxEvaluations) {
        return this.impliedVolatility(price, process, accuracy, maxEvaluations, 1.0E-7, 4.0);
    }

    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process, double accuracy, int maxEvaluations, double minVol) {
        return this.impliedVolatility(price, process, accuracy, maxEvaluations, minVol, 4.0);
    }

    public double impliedVolatility(double price, GeneralizedBlackScholesProcess process, double accuracy, int maxEvaluations, double minVol, double maxVol) {
        OneAssetOption.Engine engine;
        QL.require(!this.isExpired(), "option expired");
        SimpleQuote volQuote = new SimpleQuote();
        GeneralizedBlackScholesProcess newProcess = ImpliedVolatilityHelper.clone(process, volQuote);
        switch (this.exercise.type()) {
            case European: {
                engine = new AnalyticEuropeanEngine(newProcess);
                break;
            }
            case American: {
                engine = new FDAmericanEngine(newProcess);
                break;
            }
            case Bermudan: {
                engine = new FDBermudanEngine(newProcess);
                break;
            }
            default: {
                throw new LibraryException(UNKNOWN_EXERCISE_TYPE);
            }
        }
        return ImpliedVolatilityHelper.calculate(this, engine, volQuote, price, accuracy, maxEvaluations, minVol, maxVol);
    }

    public static abstract class EngineImpl
    extends OneAssetOption.EngineImpl
    implements Engine {
        protected EngineImpl() {
            super(new OneAssetOption.ArgumentsImpl(), new OneAssetOption.ResultsImpl());
        }

        protected EngineImpl(OneAssetOption.Arguments arguments, OneAssetOption.Results results) {
            super(arguments, results);
        }
    }

    public static interface Engine
    extends OneAssetOption.Engine {
    }
}

