/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.pricingengines.GenericEngine;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.util.Observer;

public class OneAssetOption
extends Option {
    private double delta_;
    private double deltaForward_;
    private double elasticity_;
    private double gamma_;
    private double theta_;
    private double thetaPerDay_;
    private double vega_;
    private double rho_;
    private double dividendRho_;
    private double strikeSensitivity_;
    private double itmCashProbability_;

    public OneAssetOption(Payoff payoff, Exercise exercise) {
        super(payoff, exercise);
    }

    @Override
    public boolean isExpired() {
        return this.exercise.lastDate().lt(new Settings().evaluationDate());
    }

    public double delta() {
        this.calculate();
        QL.require(this.delta_ != Double.MAX_VALUE, "delta not provided");
        return this.delta_;
    }

    public double deltaForward() {
        this.calculate();
        QL.require(this.deltaForward_ != Double.MAX_VALUE, "forward delta not provided");
        return this.deltaForward_;
    }

    public double elasticity() {
        this.calculate();
        QL.require(this.elasticity_ != Double.MAX_VALUE, "elasticity not provided");
        return this.elasticity_;
    }

    public double gamma() {
        this.calculate();
        QL.require(this.gamma_ != Double.MAX_VALUE, "gamma not provided");
        return this.gamma_;
    }

    public double theta() {
        this.calculate();
        QL.require(this.theta_ != Double.MAX_VALUE, "theta not provided");
        return this.theta_;
    }

    public double thetaPerDay() {
        this.calculate();
        QL.require(this.thetaPerDay_ != Double.MAX_VALUE, "theta per-day not provided");
        return this.thetaPerDay_;
    }

    public double vega() {
        this.calculate();
        QL.require(this.vega_ != Double.MAX_VALUE, "vega not provided");
        return this.vega_;
    }

    public double rho() {
        this.calculate();
        QL.require(this.rho_ != Double.MAX_VALUE, "rho not provided");
        return this.rho_;
    }

    public double dividendRho() {
        this.calculate();
        QL.require(this.dividendRho_ != Double.MAX_VALUE, "dividend rho not provided");
        return this.dividendRho_;
    }

    public double strikeSensitivity() {
        this.calculate();
        QL.require(this.strikeSensitivity_ != Double.MAX_VALUE, "strike sensitivity not provided");
        return this.strikeSensitivity_;
    }

    public double itmCashProbability() {
        this.calculate();
        QL.require(this.itmCashProbability_ != Double.MAX_VALUE, "in-the-money cash probability not provided");
        return this.itmCashProbability_;
    }

    @Override
    public void setupExpired() {
        super.setupExpired();
        this.itmCashProbability_ = 0.0;
        this.strikeSensitivity_ = 0.0;
        this.dividendRho_ = 0.0;
        this.rho_ = 0.0;
        this.vega_ = 0.0;
        this.thetaPerDay_ = 0.0;
        this.theta_ = 0.0;
        this.gamma_ = 0.0;
        this.elasticity_ = 0.0;
        this.deltaForward_ = 0.0;
        this.delta_ = 0.0;
    }

    @Override
    public void fetchResults(PricingEngine.Results r) {
        super.fetchResults(r);
        QL.require(Results.class.isAssignableFrom(r.getClass()), "Unexpected type for type parameter");
        ResultsImpl ri = (ResultsImpl)r;
        Option.GreeksImpl results = ri.greeks();
        QL.ensure(results != null, "no greeks returned from pricing engine");
        this.delta_ = results.delta;
        this.gamma_ = results.gamma;
        this.theta_ = results.theta;
        this.vega_ = results.vega;
        this.rho_ = results.rho;
        this.dividendRho_ = results.dividendRho;
        Option.MoreGreeksImpl moreResults = ri.moreGreeks();
        QL.ensure(moreResults != null, "no more greeks returned from pricing engine");
        this.deltaForward_ = moreResults.deltaForward;
        this.elasticity_ = moreResults.elasticity;
        this.thetaPerDay_ = moreResults.thetaPerDay;
        this.strikeSensitivity_ = moreResults.strikeSensitivity;
        this.itmCashProbability_ = moreResults.itmCashProbability;
    }

    public static abstract class EngineImpl
    extends GenericEngine<Arguments, Results>
    implements Engine {
        public EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
        }

        public EngineImpl(Arguments arguments, Results results) {
            super(arguments, results);
        }
    }

    public static class ResultsImpl
    extends Instrument.ResultsImpl
    implements Results {
        private final Option.GreeksImpl greeks = new Option.GreeksImpl();
        private final Option.MoreGreeksImpl moreGreeks = new Option.MoreGreeksImpl();

        public final Option.GreeksImpl greeks() {
            return this.greeks;
        }

        public final Option.MoreGreeksImpl moreGreeks() {
            return this.moreGreeks;
        }

        @Override
        public void reset() {
            super.reset();
            this.greeks.reset();
            this.moreGreeks.reset();
        }
    }

    public static class ArgumentsImpl
    extends Option.ArgumentsImpl
    implements Arguments {
    }

    public static interface Engine
    extends PricingEngine,
    Observer {
    }

    public static interface Results
    extends Instrument.Results,
    Option.Greeks,
    Option.MoreGreeks {
    }

    public static interface Arguments
    extends Option.Arguments {
    }
}

