/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.Settings;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.instruments.Forward;
import org.jquantlib.instruments.ForwardTypePayoff;
import org.jquantlib.instruments.Position;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeUnit;

public class ForwardRateAgreement
extends Forward {
    protected InterestRate forwardRate;
    protected InterestRate strikeForwardRate;
    protected Position fraType;
    protected double notional;
    protected IborIndex index;

    public ForwardRateAgreement(Date valueDate, Date maturityDate, Position type, double strikeForwardRate, double notionalAmount, IborIndex index) {
        this(valueDate, maturityDate, type, strikeForwardRate, notionalAmount, index, new Handle<YieldTermStructure>());
    }

    public ForwardRateAgreement(Date valueDate, Date maturityDate, Position type, double strikeForwardRate, double notionalAmount, IborIndex index, Handle<YieldTermStructure> discountCurve) {
        super(index.dayCounter(), index.fixingCalendar(), index.businessDayConvention(), index.fixingDays(), null, valueDate, maturityDate, discountCurve);
        this.fraType = type;
        this.notional = notionalAmount;
        this.index = index;
        Date fixingDate = this.calendar.advance(valueDate, -1 * this.settlementDays, TimeUnit.Days);
        this.forwardRate = new InterestRate(index.fixing(fixingDate), index.dayCounter(), Compounding.Simple, Frequency.Once);
        this.strikeForwardRate = new InterestRate(strikeForwardRate, index.dayCounter(), Compounding.Simple, Frequency.Once);
        double strike = this.notional * this.strikeForwardRate.compoundFactor(valueDate, maturityDate);
        this.payoff = new ForwardTypePayoff(this.fraType, strike);
        this.incomeDiscountCurve = discountCurve;
        this.underlyingIncome = 0.0;
        index.addObserver(this);
    }

    @Override
    public Date settlementDate() {
        return this.calendar.advance(new Settings().evaluationDate(), this.settlementDays, TimeUnit.Days);
    }

    @Override
    public boolean isExpired() {
        if (new Settings().isTodaysPayments()) {
            return this.valueDate.lt(this.settlementDate());
        }
        return this.valueDate.le(this.settlementDate());
    }

    @Override
    public double spotIncome(Handle<YieldTermStructure> incomeDiscountCurve) {
        return 0.0;
    }

    @Override
    public double spotValue() {
        this.calculate();
        double compoundFactor = this.forwardRate.compoundFactor(this.valueDate, this.maturityDate);
        double discount = ((YieldTermStructure)this.discountCurve.currentLink()).discount(this.maturityDate);
        return this.notional * compoundFactor * discount;
    }

    public InterestRate forwardRate() {
        this.calculate();
        return this.forwardRate;
    }

    @Override
    public void performCalculations() {
        Date fixingDate = this.calendar.advance(this.valueDate, -1 * this.settlementDays, TimeUnit.Days);
        this.forwardRate = new InterestRate(this.index.fixing(fixingDate), this.index.dayCounter(), Compounding.Simple, Frequency.Once);
        this.underlyingSpotValue = this.spotValue();
        this.underlyingIncome = 0.0;
        super.performCalculations();
    }
}

