/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.CashFlows;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Date;

public class CapFloor
extends Instrument {
    private final Type type_;
    private final Leg floatingLeg_;
    private List<Double> capRates_;
    private List<Double> floorRates_;
    private final Handle<YieldTermStructure> termStructure_;

    public CapFloor(Type type, Leg floatingLeg, List<Double> capRates, List<Double> floorRates, Handle<YieldTermStructure> termStructure, PricingEngine engine) {
        QL.validateExperimentalMode();
        this.type_ = type;
        this.floatingLeg_ = floatingLeg;
        this.capRates_ = capRates;
        this.floorRates_ = floorRates;
        this.termStructure_ = termStructure;
        this.setPricingEngine(engine);
        if (this.type_ == Type.Cap || this.type_ == Type.Collar) {
            QL.require(this.capRates_.size() > 0, "no cap rates given");
            while (this.capRates_.size() < this.floatingLeg_.size()) {
                this.capRates_.add(this.capRates_.get(this.capRates_.size() - 1));
            }
        }
        if (this.type_ == Type.Floor || this.type_ == Type.Collar) {
            QL.require(this.floorRates_.size() > 0, "no floor rates given");
            while (this.floorRates_.size() < this.floatingLeg_.size()) {
                this.floorRates_.add(this.floorRates_.get(this.floorRates_.size() - 1));
            }
        }
        Date evaluationDate = new Settings().evaluationDate();
        for (CashFlow cashFlow : this.floatingLeg_) {
            cashFlow.addObserver(this);
        }
        this.termStructure_.addObserver(this);
        evaluationDate.addObserver(this);
    }

    public CapFloor(Type type, Leg floatingLeg, List<Double> strikes, Handle<YieldTermStructure> termStructure, PricingEngine engine) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.type_ = type;
        this.floatingLeg_ = floatingLeg;
        this.termStructure_ = termStructure;
        this.setPricingEngine(engine);
        QL.require(strikes.size() > 0, "no strikes given");
        if (this.type_ == Type.Cap) {
            this.capRates_ = strikes;
            while (this.capRates_.size() < this.floatingLeg_.size()) {
                this.capRates_.add(this.capRates_.get(this.capRates_.size() - 1));
            }
        } else if (this.type_ == Type.Floor) {
            this.floorRates_ = strikes;
            while (this.floorRates_.size() < this.floatingLeg_.size()) {
                this.floorRates_.add(this.floorRates_.get(this.floorRates_.size() - 1));
            }
        } else {
            throw new LibraryException("only Cap/Floor types allowed in this constructor");
        }
        Date evaluationDate = new Settings().evaluationDate();
        for (CashFlow cashFlow : this.floatingLeg_) {
            cashFlow.addObserver(this);
        }
        this.termStructure_.addObserver(this);
        evaluationDate.addObserver(this);
    }

    public double atmRate() {
        return CashFlows.getInstance().atmRate(this.floatingLeg_, this.termStructure_);
    }

    @Override
    public boolean isExpired() {
        Date lastPaymentDate = Date.minDate();
        for (int i = 0; i < this.floatingLeg_.size(); ++i) {
            lastPaymentDate = lastPaymentDate.le(((CashFlow)this.floatingLeg_.get(i)).date()) ? ((CashFlow)this.floatingLeg_.get(i)).date() : lastPaymentDate;
        }
        return lastPaymentDate.le(this.termStructure_.currentLink().referenceDate());
    }

    public Date startDate() {
        return CashFlows.getInstance().startDate(this.floatingLeg_);
    }

    public Date maturityDate() {
        return CashFlows.getInstance().maturityDate(this.floatingLeg_);
    }

    public Date lastFixingDate() {
        CashFlow lastCoupon = (CashFlow)this.floatingLeg_.get(this.floatingLeg_.size() - 1);
        FloatingRateCoupon lastFloatingCoupon = (FloatingRateCoupon)lastCoupon;
        return lastFloatingCoupon.fixingDate();
    }

    @Override
    protected void performCalculations() throws ArithmeticException {
    }

    @Override
    protected void setupArguments(PricingEngine.Arguments arguments) {
    }

    public static enum Type {
        Cap,
        Floor,
        Collar;

    }
}

