/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.cashflow.CashFlows;
import org.jquantlib.cashflow.Coupon;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.cashflow.SimpleCashFlow;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.EarlierThanCashFlowComparator;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.lang.iterators.Iterables;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.Ops;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.pricingengines.GenericEngine;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.bond.DiscountingBondEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.ZeroSpreadedTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.Observer;

public class Bond
extends Instrument {
    protected int settlementDays_;
    protected Calendar calendar_;
    protected List<Date> notionalSchedule_;
    protected List<Double> notionals_;
    protected Leg cashflows_;
    protected Leg redemptions_;
    protected Date maturityDate_;
    protected Date issueDate_;
    protected double settlementValue_;

    protected Bond(int settlementDays, Calendar calendar, Date issueDate, Leg coupons) {
        this.settlementDays_ = settlementDays;
        this.calendar_ = calendar;
        this.cashflows_ = coupons;
        this.issueDate_ = issueDate.clone();
        this.notionals_ = new ArrayList<Double>();
        this.notionalSchedule_ = new ArrayList<Date>();
        this.redemptions_ = new Leg();
        if (!coupons.isEmpty()) {
            Collections.sort(this.cashflows_, new EarlierThanCashFlowComparator());
            this.maturityDate_ = coupons.last().date();
            this.addRedemptionsToCashflows();
        }
        Date evaluationDate = new Settings().evaluationDate();
        evaluationDate.addObserver(this);
    }

    protected Bond(int settlementDays, Calendar calendar) {
        this(settlementDays, calendar, new Date(), new Leg());
    }

    protected Bond(int settlementDays, Calendar calendar, Date issueDate) {
        this(settlementDays, calendar, issueDate, new Leg());
    }

    public Bond(int settlementDays, Calendar calendar, double faceAmount, Date maturityDate, Date issueDate, Leg cashflows) {
        this.settlementDays_ = settlementDays;
        this.calendar_ = calendar;
        this.cashflows_ = cashflows;
        this.maturityDate_ = maturityDate.clone();
        this.issueDate_ = issueDate.clone();
        this.notionalSchedule_ = new ArrayList<Date>();
        this.notionals_ = new ArrayList<Double>();
        this.redemptions_ = new Leg();
        if (!cashflows.isEmpty()) {
            this.notionalSchedule_.add(new Date());
            this.notionals_.add(faceAmount);
            this.notionalSchedule_.add(maturityDate.clone());
            this.notionals_.add(0.0);
            CashFlow last = cashflows.last();
            this.redemptions_.add(last);
            cashflows.remove(last);
            Collections.sort(cashflows, new EarlierThanCashFlowComparator());
            cashflows.add(last);
        }
        Date evaluationDate = new Settings().evaluationDate();
        evaluationDate.addObserver(this);
    }

    protected Bond(int settlementDays, Calendar calendar, double faceAmount, Date maturityDate) {
        this(settlementDays, calendar, faceAmount, maturityDate, new Date(), new Leg());
    }

    protected Bond(int settlementDays, Calendar calendar, double faceAmount, Date maturityDate, Date issueDate) {
        this(settlementDays, calendar, faceAmount, maturityDate, issueDate, new Leg());
    }

    public int settlementDays() {
        return this.settlementDays_;
    }

    public Calendar calendar() {
        return this.calendar_;
    }

    public double faceAmount() {
        return this.notionals_.get(0);
    }

    public List<Double> notionals() {
        return this.notionals_;
    }

    public Leg cashflows() {
        return this.cashflows_;
    }

    public Leg redemptions() {
        return this.redemptions_;
    }

    public Date maturityDate() {
        return !this.maturityDate_.isNull() ? this.maturityDate_ : this.cashflows_.last().date();
    }

    public Date issueDate() {
        return this.issueDate_;
    }

    public double notional() {
        return this.notional(new Date());
    }

    public double notional(Date date) {
        if (date.isNull()) {
            date = this.settlementDate();
        }
        if (date.gt(this.notionalSchedule_.get(this.notionalSchedule_.size() - 1))) {
            return 0.0;
        }
        int index = Collections.binarySearch(this.notionalSchedule_, date);
        if (index < 0) {
            index = -(index + 1);
        }
        if (date.le(this.notionalSchedule_.get(index))) {
            return this.notionals_.get(index - 1);
        }
        if (new Settings().isTodaysPayments()) {
            return this.notionals_.get(index - 1);
        }
        return this.notionals_.get(index);
    }

    public CashFlow redemption() {
        QL.require(this.redemptions_.size() == 1, "multiple redemption cash flows given");
        return this.redemptions_.last();
    }

    public Date settlementDate() {
        return this.settlementDate(new Date());
    }

    public Date settlementDate(Date date) {
        Date d = date.isNull() ? new Settings().evaluationDate() : date;
        Date settlement = this.calendar_.advance(d, this.settlementDays_, TimeUnit.Days);
        return this.issueDate_.isNull() ? settlement : Date.max(settlement, this.issueDate_.clone());
    }

    public double cleanPrice() {
        return this.dirtyPrice() - this.accruedAmount(this.settlementDate());
    }

    public double dirtyPrice() {
        return this.settlementValue() / this.notional(this.settlementDate()) * 100.0;
    }

    public double settlementValue() {
        this.calculate();
        QL.require(this.settlementValue_ != Double.MAX_VALUE, "settlement value not provided");
        return this.settlementValue_;
    }

    public double settlementValue(double cleanPrice) {
        double dirtyPrice = cleanPrice + this.accruedAmount(this.settlementDate());
        return dirtyPrice / 100.0 * this.notional(this.settlementDate());
    }

    public double yield(DayCounter dc, Compounding comp, Frequency freq, double accuracy, int maxEvaluations) {
        Brent solver = new Brent();
        solver.setMaxEvaluations(maxEvaluations);
        YieldFinder objective = new YieldFinder(this.notional(this.settlementDate()), this.cashflows_, this.dirtyPrice(), dc, comp, freq, this.settlementDate());
        return solver.solve(objective, accuracy, 0.02, 0.0, 1.0);
    }

    public double yield(DayCounter dc, Compounding comp, Frequency freq) {
        return this.yield(dc, comp, freq, 1.0E-8, 100);
    }

    public double cleanPrice(double yield, DayCounter dc, Compounding comp, Frequency freq, Date settlementDate) {
        if (settlementDate.isNull()) {
            settlementDate = this.settlementDate();
        }
        return this.dirtyPrice(yield, dc, comp, freq, settlementDate) - this.accruedAmount(settlementDate);
    }

    public double cleanPrice(double yield, DayCounter dc, Compounding comp, Frequency freq) {
        return this.cleanPrice(yield, dc, comp, freq, new Date());
    }

    public double dirtyPrice(double yield, DayCounter dc, Compounding comp, Frequency freq, Date settlementDate) {
        if (settlementDate.isNull()) {
            settlementDate = this.settlementDate();
        }
        return Bond.dirtyPriceFromYield(this.notional(settlementDate), this.cashflows_, yield, dc, comp, freq, settlementDate);
    }

    public double dirtyPrice(double yield, DayCounter dc, Compounding comp, Frequency freq) {
        return this.dirtyPrice(yield, dc, comp, freq, new Date());
    }

    public double yield(double cleanPrice, DayCounter dc, Compounding comp, Frequency freq, Date settlementDate, double accuracy, int maxEvaluations) {
        if (settlementDate.isNull()) {
            settlementDate = this.settlementDate();
        }
        Brent solver = new Brent();
        solver.setMaxEvaluations(maxEvaluations);
        double dirtyPrice = cleanPrice + this.accruedAmount(settlementDate);
        YieldFinder objective = new YieldFinder(this.notional(settlementDate), this.cashflows_, dirtyPrice, dc, comp, freq, settlementDate);
        return solver.solve(objective, accuracy, 0.02, 0.0, 1.0);
    }

    public double yield(double cleanPrice, DayCounter dc, Compounding comp, Frequency freq) {
        return this.yield(cleanPrice, dc, comp, freq, new Date(), 1.0E-8, 100);
    }

    public double yield(double cleanPrice, DayCounter dc, Compounding comp, Frequency freq, Date settlementDate) {
        return this.yield(cleanPrice, dc, comp, freq, settlementDate, 1.0E-8, 100);
    }

    public double yield(double cleanPrice, DayCounter dc, Compounding comp, Frequency freq, Date settlementDate, double accuracy) {
        return this.yield(cleanPrice, dc, comp, freq, settlementDate, accuracy, 100);
    }

    public double cleanPriceFromZSpread(double zSpread, DayCounter dc, Compounding comp, Frequency freq, Date settlementDate) {
        double p = this.dirtyPriceFromZSpread(zSpread, dc, comp, freq, settlementDate);
        return p - this.accruedAmount(settlementDate);
    }

    public double cleanPriceFromZSpread(double zSpread, DayCounter dc, Compounding comp, Frequency freq) {
        return this.cleanPriceFromZSpread(zSpread, dc, comp, freq, new Date());
    }

    public double dirtyPriceFromZSpread(double zSpread, DayCounter dc, Compounding comp, Frequency freq, Date settlement) {
        if (settlement.isNull()) {
            settlement = this.settlementDate();
        }
        QL.require(this.engine != null, "null pricing engine");
        QL.require(DiscountingBondEngine.class.isAssignableFrom(this.engine.getClass()), "Unexpected type for type parameter");
        DiscountingBondEngine discountingBondEngine = (DiscountingBondEngine)this.engine;
        return Bond.dirtyPriceFromZSpreadFunction(this.notional(settlement), this.cashflows_, zSpread, dc, comp, freq, settlement, discountingBondEngine.discountCurve());
    }

    public double dirtyPriceFromZSpread(double zSpread, DayCounter dc, Compounding comp, Frequency freq) {
        return this.dirtyPriceFromZSpread(zSpread, dc, comp, freq, new Date());
    }

    public double accruedAmount() {
        return this.accruedAmount(new Date());
    }

    public double accruedAmount(Date settlement) {
        CashFlow cf;
        if (settlement.isNull()) {
            settlement = this.settlementDate();
        }
        if ((cf = CashFlows.getInstance().nextCashFlow(this.cashflows_, settlement)) == null) {
            return 0.0;
        }
        Date paymentDate = cf.date();
        boolean firstCouponFound = false;
        double nominal = Double.MAX_VALUE;
        double accrualPeriod = Double.MAX_VALUE;
        DayCounter dc = null;
        double result = 0.0;
        int startIndex = this.cashflows_.indexOf(cf);
        for (CashFlow flow : Iterables.unmodifiableIterable(this.cashflows_.listIterator(startIndex))) {
            Coupon cp;
            if (flow.date().ne(paymentDate) || (cp = Coupon.class.isAssignableFrom(flow.getClass()) ? (Coupon)flow : null) == null) continue;
            if (firstCouponFound) {
                QL.require(nominal == cp.nominal() && accrualPeriod == cp.accrualPeriod() && dc.equals(cp.dayCounter()), "cannot aggregate accrued amount of two different coupons on " + paymentDate.toString());
            } else {
                firstCouponFound = true;
                nominal = cp.nominal();
                accrualPeriod = cp.accrualPeriod();
                dc = cp.dayCounter();
            }
            result += cp.accruedAmount(settlement);
        }
        return result / this.notional(settlement) * 100.0;
    }

    @Override
    public boolean isExpired() {
        return this.cashflows_.last().hasOccurred(this.settlementDate());
    }

    public double nextCoupon(Date settlement) {
        if (settlement.isNull()) {
            settlement = this.settlementDate();
        }
        return CashFlows.getInstance().nextCouponRate(this.cashflows_, settlement);
    }

    public double nextCoupon() {
        return this.nextCoupon(new Date());
    }

    public double previousCoupon(Date settlement) {
        if (settlement.isNull()) {
            settlement = this.settlementDate();
        }
        return CashFlows.getInstance().previousCouponRate(this.cashflows_, settlement);
    }

    public double previousCoupon() {
        return this.previousCoupon(new Date());
    }

    @Override
    protected void setupExpired() {
        super.setupExpired();
        this.settlementValue_ = 0.0;
    }

    @Override
    protected void setupArguments(PricingEngine.Arguments args) {
        QL.require(args != null, "Null arguments passed");
        QL.require(ArgumentsImpl.class.isAssignableFrom(args.getClass()), "Unexpected type for type parameter");
        ArgumentsImpl arguments = (ArgumentsImpl)args;
        arguments.settlementDate = this.settlementDate();
        arguments.cashflows = (Leg)this.cashflows_.clone();
        arguments.calendar = this.calendar_;
    }

    @Override
    protected void fetchResults(PricingEngine.Results r) {
        QL.require(r != null, "Null arguments passed");
        super.fetchResults(r);
        QL.require(ResultsImpl.class.isAssignableFrom(r.getClass()), "Unexpected type for type parameter");
        ResultsImpl results = (ResultsImpl)r;
        this.settlementValue_ = results.settlementValue;
    }

    protected void addRedemptionsToCashflows(List<Double> redemptions) {
        this.calculateNotionalsFromCashflows();
        this.redemptions_.clear();
        for (int i = 1; i < this.notionalSchedule_.size(); ++i) {
            double R = i < redemptions.size() ? redemptions.get(i) : (!redemptions.isEmpty() ? redemptions.get(redemptions.size() - 1) : 100.0);
            double amount = R / 100.0 * (this.notionals_.get(i - 1) - this.notionals_.get(i));
            SimpleCashFlow redemption = new SimpleCashFlow(amount, this.notionalSchedule_.get(i));
            this.cashflows_.add(redemption);
            this.redemptions_.add(redemption);
        }
        Collections.sort(this.cashflows_, new EarlierThanCashFlowComparator());
    }

    protected void addRedemptionsToCashflows(double redemption) {
        ArrayList<Double> redemptions = new ArrayList<Double>();
        redemptions.add(redemption);
        this.addRedemptionsToCashflows(redemptions);
    }

    protected void addRedemptionsToCashflows(double[] redemptionsArr) {
        ArrayList<Double> redemptions = new ArrayList<Double>();
        for (double d : redemptionsArr) {
            redemptions.add(new Double(d));
        }
        this.addRedemptionsToCashflows(redemptions);
    }

    protected void addRedemptionsToCashflows() {
        this.addRedemptionsToCashflows(new ArrayList<Double>());
    }

    protected void calculateNotionalsFromCashflows() {
        this.notionalSchedule_.clear();
        this.notionals_.clear();
        Date lastPaymentDate = new Date();
        this.notionalSchedule_.add(new Date());
        for (int i = 0; i < this.cashflows_.size(); ++i) {
            Coupon coupon;
            Object cfObj = this.cashflows_.get(i);
            Coupon coupon2 = coupon = Coupon.class.isAssignableFrom(cfObj.getClass()) ? (Coupon)cfObj : null;
            if (coupon == null) continue;
            double notional = coupon.nominal();
            if (this.notionals_.isEmpty()) {
                this.notionals_.add(coupon.nominal());
                lastPaymentDate = coupon.date().clone();
                continue;
            }
            if (!Closeness.isClose(notional, this.notionals_.get(this.notionals_.size() - 1))) {
                QL.require(notional < this.notionals_.get(this.notionals_.size() - 1), "increasing coupon notionals");
                this.notionals_.add(coupon.nominal());
                this.notionalSchedule_.add(lastPaymentDate);
                lastPaymentDate = coupon.date().clone();
                continue;
            }
            lastPaymentDate = coupon.date().clone();
        }
        QL.require(!this.notionals_.isEmpty(), "no coupons provided");
        this.notionals_.add(0.0);
        this.notionalSchedule_.add(lastPaymentDate);
    }

    protected void setSingleRedemption(double notional, double redemption, Date date) {
        this.redemptions_.clear();
        this.notionalSchedule_.add(new Date());
        this.notionals_.add(notional);
        this.notionalSchedule_.add(date);
        this.notionals_.add(0.0);
        SimpleCashFlow redemptionCashflow = new SimpleCashFlow(notional * redemption / 100.0, date);
        this.cashflows_.add(redemptionCashflow);
        this.redemptions_.add(redemptionCashflow);
    }

    public static double dirtyPriceFromYield(double faceAmount, Leg cashflows, double yield, DayCounter dayCounter, Compounding compounding, Frequency frequency, Date settlement) {
        if (frequency == Frequency.NoFrequency || frequency == Frequency.Once) {
            frequency = Frequency.Annual;
        }
        InterestRate y = new InterestRate(yield, dayCounter, compounding, frequency);
        double price = 0.0;
        double discount = 1.0;
        Date lastDate = new Date();
        for (int i = 0; i < cashflows.size(); ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(settlement)) continue;
            Date couponDate = ((CashFlow)cashflows.get(i)).date();
            double amount = ((CashFlow)cashflows.get(i)).amount();
            if (lastDate.isNull()) {
                if (i > 0) {
                    lastDate = ((CashFlow)cashflows.get(i - 1)).date().clone();
                } else {
                    Object cpnObj = cashflows.get(i);
                    Coupon coupon = Coupon.class.isAssignableFrom(cpnObj.getClass()) ? (Coupon)cpnObj : null;
                    lastDate = coupon != null ? coupon.accrualStartDate().clone() : couponDate.sub(new Period(1, TimeUnit.Years));
                }
                discount *= y.discountFactor(settlement, couponDate, lastDate, couponDate);
            } else {
                discount *= y.discountFactor(lastDate, couponDate);
            }
            lastDate = couponDate.clone();
            price += amount * discount;
        }
        return price / faceAmount * 100.0;
    }

    static double dirtyPriceFromZSpreadFunction(double faceAmount, Leg cashflows, double zSpread, DayCounter dc, Compounding comp, Frequency freq, Date settlement, Handle<YieldTermStructure> discountCurve) {
        assert (freq != Frequency.NoFrequency && freq != Frequency.Once) : "invalid frequency:" + freq.toString();
        Handle<Quote> zSpreadQuoteHandle = new Handle<Quote>(new SimpleQuote(zSpread));
        ZeroSpreadedTermStructure spreadedCurve = new ZeroSpreadedTermStructure(discountCurve, zSpreadQuoteHandle, comp, freq, dc);
        double price = 0.0;
        for (int i = 0; i < cashflows.size(); ++i) {
            if (((CashFlow)cashflows.get(i)).hasOccurred(settlement)) continue;
            Date couponDate = ((CashFlow)cashflows.get(i)).date();
            double amount = ((CashFlow)cashflows.get(i)).amount();
            price += amount * spreadedCurve.discount(couponDate);
        }
        return (price /= spreadedCurve.discount(settlement)) / faceAmount * 100.0;
    }

    public static abstract class EngineImpl
    extends GenericEngine<Arguments, Results>
    implements Engine {
        protected EngineImpl() {
            super(new ArgumentsImpl(), new ResultsImpl());
        }
    }

    public static class ResultsImpl
    extends Instrument.ResultsImpl
    implements Results {
        public double settlementValue;

        @Override
        public void reset() {
            this.settlementValue = Double.MAX_VALUE;
            super.reset();
        }
    }

    public static class ArgumentsImpl
    implements Arguments {
        public Date settlementDate;
        public Leg cashflows;
        public Calendar calendar;

        @Override
        public void validate() {
            QL.require(!this.settlementDate.isNull(), "no settlement date provided");
            QL.require(!this.cashflows.isEmpty(), "no cash flow provided");
            for (CashFlow cf : this.cashflows) {
                QL.require(cf != null, "null cash flow provided");
            }
        }
    }

    public static interface Engine
    extends PricingEngine,
    Observer {
    }

    public static interface Results
    extends Instrument.Results {
    }

    public static interface Arguments
    extends Instrument.Arguments {
    }

    public static class YieldFinder
    implements Ops.DoubleOp {
        private final double faceAmount_;
        private final Leg cashflows_;
        private final double dirtyPrice_;
        private final Compounding compounding_;
        private final DayCounter dayCounter_;
        private final Frequency frequency_;
        private final Date settlement_;

        public YieldFinder(double faceAmount, Leg cashflows, double dirtyPrice, DayCounter dayCounter, Compounding compounding, Frequency frequency, Date settlement) {
            this.faceAmount_ = faceAmount;
            this.cashflows_ = cashflows;
            this.dirtyPrice_ = dirtyPrice;
            this.compounding_ = compounding;
            this.dayCounter_ = dayCounter;
            this.frequency_ = frequency;
            this.settlement_ = settlement.clone();
        }

        @Override
        public double op(double yield) {
            return this.dirtyPrice_ - Bond.dirtyPriceFromYield(this.faceAmount_, this.cashflows_, yield, this.dayCounter_, this.compounding_, this.frequency_, this.settlement_);
        }
    }
}

