/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.indexes;

import org.jquantlib.QL;
import org.jquantlib.currencies.Currency;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.InterestRateIndex;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;

public class IborIndex
extends InterestRateIndex {
    private final BusinessDayConvention convention;
    private final Handle<YieldTermStructure> termStructure;
    private final boolean endOfMonth;

    public IborIndex(String familyName, Period tenor, int fixingDays, Currency currency, Calendar fixingCalendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter, Handle<YieldTermStructure> h) {
        super(familyName, tenor, fixingDays, currency, fixingCalendar, dayCounter);
        this.convention = convention;
        this.termStructure = h;
        this.endOfMonth = endOfMonth;
        if (this.termStructure != null) {
            this.termStructure.addObserver(this);
        }
    }

    public IborIndex(String familyName, Period tenor, int fixingDays, Currency currency, Calendar fixingCalendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        this(familyName, tenor, fixingDays, currency, fixingCalendar, convention, endOfMonth, dayCounter, new Handle<YieldTermStructure>());
    }

    public Handle<IborIndex> clone(Handle<YieldTermStructure> h) {
        IborIndex clone = new IborIndex(this.familyName(), this.tenor(), this.fixingDays(), this.currency(), this.fixingCalendar(), this.businessDayConvention(), this.endOfMonth(), this.dayCounter(), h);
        return new Handle<IborIndex>(clone);
    }

    protected static BusinessDayConvention euriborConvention(Period p) {
        switch (p.units()) {
            case Days: 
            case Weeks: {
                return BusinessDayConvention.Following;
            }
            case Months: 
            case Years: {
                return BusinessDayConvention.ModifiedFollowing;
            }
        }
        throw new LibraryException("invalid time units");
    }

    protected static BusinessDayConvention eurliborConvention(Period p) {
        switch (p.units()) {
            case Days: 
            case Weeks: {
                return BusinessDayConvention.Following;
            }
            case Months: 
            case Years: {
                return BusinessDayConvention.ModifiedFollowing;
            }
        }
        throw new LibraryException("invalid time units");
    }

    protected static boolean euriborEOM(Period p) {
        switch (p.units()) {
            case Days: 
            case Weeks: {
                return false;
            }
            case Months: 
            case Years: {
                return true;
            }
        }
        throw new LibraryException("invalid time units");
    }

    protected static boolean eurliborEOM(Period p) {
        switch (p.units()) {
            case Days: 
            case Weeks: {
                return false;
            }
            case Months: 
            case Years: {
                return true;
            }
        }
        throw new LibraryException("invalid time units");
    }

    protected static BusinessDayConvention liborConvention(Period p) {
        switch (p.units()) {
            case Days: 
            case Weeks: {
                return BusinessDayConvention.Following;
            }
            case Months: 
            case Years: {
                return BusinessDayConvention.ModifiedFollowing;
            }
        }
        throw new LibraryException("invalid time units");
    }

    protected static boolean liborEOM(Period p) {
        switch (p.units()) {
            case Days: 
            case Weeks: {
                return false;
            }
            case Months: 
            case Years: {
                return true;
            }
        }
        throw new LibraryException("invalid time units");
    }

    public BusinessDayConvention businessDayConvention() {
        return this.convention;
    }

    public boolean endOfMonth() {
        return this.endOfMonth;
    }

    @Override
    protected double forecastFixing(Date fixingDate) {
        QL.require(!this.termStructure.empty(), "no forecasting term structure set to " + this.name());
        Date fixingValueDate = this.valueDate(fixingDate);
        Date endValueDate = this.maturityDate(fixingValueDate);
        double fixingDiscount = this.termStructure.currentLink().discount(fixingValueDate);
        double endDiscount = this.termStructure.currentLink().discount(endValueDate);
        double fixingPeriod = this.dayCounter().yearFraction(fixingValueDate, endValueDate);
        return (fixingDiscount / endDiscount - 1.0) / fixingPeriod;
    }

    @Override
    public Handle<YieldTermStructure> termStructure() {
        return this.termStructure;
    }

    @Override
    public Date maturityDate(Date valueDate) {
        return this.fixingCalendar().advance(valueDate, this.tenor, this.convention, this.endOfMonth);
    }
}

