/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.currencies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.currencies.America;
import org.jquantlib.currencies.Currency;
import org.jquantlib.currencies.Europe;
import org.jquantlib.currencies.ExchangeRate;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.lang.iterators.Iterables;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;

public class ExchangeRateManager {
    private static volatile ExchangeRateManager instance = null;
    private final HashMap<Object, List<Entry>> data_ = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExchangeRateManager getInstance() {
        if (instance != null) return instance;
        Class<ExchangeRateManager> clazz = ExchangeRateManager.class;
        synchronized (ExchangeRateManager.class) {
            if (instance != null) return instance;
            instance = new ExchangeRateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ExchangeRateManager() {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.addKnownRates();
    }

    public void add(ExchangeRate rate, Date startDate, Date endDate) {
        int k = this.hash(rate.source(), rate.target());
        if (this.data_.get(k) == null) {
            this.data_.put(k, new ArrayList());
        }
        this.data_.get(k).add(0, new Entry(rate, startDate, endDate));
    }

    public void add(ExchangeRate rate) {
        this.add(rate, Date.minDate(), Date.maxDate());
    }

    public ExchangeRate lookup(Currency source, Currency target) {
        return this.lookup(source, target, Date.todaysDate(), ExchangeRate.Type.Derived);
    }

    public ExchangeRate lookup(Currency source, Currency target, Date date) {
        return this.lookup(source, target, date, ExchangeRate.Type.Derived);
    }

    public ExchangeRate lookup(Currency source, Currency target, Date date, ExchangeRate.Type type) {
        if (source.eq(target)) {
            return new ExchangeRate(source, target, 1.0);
        }
        if (date.isToday()) {
            date = new Settings().evaluationDate();
        }
        if (type == ExchangeRate.Type.Direct) {
            return this.directLookup(source, target, date);
        }
        if (!source.triangulationCurrency().empty()) {
            Currency link = source.triangulationCurrency();
            if (link.eq(target)) {
                return this.directLookup(source, link, date);
            }
            return ExchangeRate.chain(this.directLookup(source, link, date), this.lookup(link, target, date));
        }
        if (!target.triangulationCurrency().empty()) {
            Currency link = target.triangulationCurrency();
            if (source.eq(link)) {
                return this.directLookup(link, target, date);
            }
            return ExchangeRate.chain(this.lookup(source, link, date), this.directLookup(link, target, date));
        }
        return this.smartLookup(source, target, date);
    }

    public void clear() {
        this.data_.clear();
        this.addKnownRates();
    }

    public int hash(Currency c1, Currency c2) {
        return Math.min(c1.numericCode(), c2.numericCode()) * 1000 + Math.max(c1.numericCode(), c2.numericCode());
    }

    public boolean hashes(int k, Currency c) {
        return c.numericCode() == k % 1000 || c.numericCode() == k / 1000;
    }

    private void addKnownRates() {
        Date maxDate = Date.maxDate();
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.ATSCurrency(), 13.7603), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.BEFCurrency(), 40.3399), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.DEMCurrency(), 1.95583), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.ESPCurrency(), 166.386), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.FIMCurrency(), 5.94573), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.FRFCurrency(), 6.55957), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.GRDCurrency(), 340.75), new Date(1, Month.January, 2001), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.IEPCurrency(), 0.787564), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.ITLCurrency(), 1936.27), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.LUFCurrency(), 40.3399), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.NLGCurrency(), 2.20371), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.EURCurrency(), new Europe.PTECurrency(), 200.482), new Date(1, Month.January, 1999), maxDate);
        this.add(new ExchangeRate(new Europe.TRYCurrency(), new Europe.TRLCurrency(), 1000000.0), new Date(1, Month.January, 2005), maxDate);
        this.add(new ExchangeRate(new Europe.RONCurrency(), new Europe.ROLCurrency(), 10000.0), new Date(1, Month.July, 2005), maxDate);
        this.add(new ExchangeRate(new America.PENCurrency(), new America.PEICurrency(), 1000000.0), new Date(1, Month.July, 1991), maxDate);
        this.add(new ExchangeRate(new America.PEICurrency(), new America.PEHCurrency(), 1000.0), new Date(1, Month.February, 1985), maxDate);
    }

    private ExchangeRate directLookup(Currency source, Currency target, Date date) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        ExchangeRate rate = null;
        rate = this.fetch(source, target, date);
        QL.require(rate != null, "no direct conversion available");
        return rate;
    }

    private ExchangeRate smartLookup(Currency source, Currency target, Date date) {
        return this.smartLookup(source, target, date, new int[0]);
    }

    private ExchangeRate smartLookup(Currency source, Currency target, Date date, int[] forbidden) {
        ExchangeRate direct = this.fetch(source, target, date);
        if (direct != null) {
            return direct;
        }
        int[] temp = (int[])forbidden.clone();
        forbidden = new int[temp.length + 1];
        System.arraycopy(temp, 0, forbidden, 0, temp.length);
        forbidden[forbidden.length - 1] = source.numericCode();
        for (Object key : Iterables.unmodifiableIterable(this.data_.keySet())) {
            if (!this.hashes((Integer)key, source) || this.data_.get(key).isEmpty()) continue;
            Entry e = this.data_.get(key).get(0);
            Currency other = source == e.rate.source() ? e.rate.target() : e.rate.source();
            if (this.match(forbidden, other.numericCode()) != forbidden.length - 1) continue;
            ExchangeRate head = this.fetch(source, other, date);
            try {
                if (head == null) continue;
                ExchangeRate tail = this.smartLookup(other, target, date, forbidden);
                return ExchangeRate.chain(head, tail);
            }
            catch (Exception exception) {
            }
        }
        throw new LibraryException("no conversion available");
    }

    public ExchangeRate fetch(Currency source, Currency target, Date date) {
        List<Entry> rates = this.data_.get(this.hash(source, target));
        int i = this.matchValidateAt(rates, date);
        return i == rates.size() - 1 ? rates.get((int)i).rate : null;
    }

    private int match(int[] list, int value) {
        for (int i = 0; i < list.length; ++i) {
            if (value != list[i]) continue;
            return i;
        }
        return -1;
    }

    private int matchValidateAt(List<Entry> rates, Date date) {
        Valid_at va = new Valid_at(date);
        for (int i = 0; i < rates.size(); ++i) {
            if (!va.operator(rates.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static class Entry {
        public ExchangeRate rate;
        public Date startDate;
        public Date endDate;

        public Entry(ExchangeRate rate, Date start, Date end) {
            this.rate = rate;
            this.startDate = start;
            this.endDate = end;
        }
    }

    public static class Valid_at {
        Date d;

        public Valid_at(Date d) {
            this.d = d;
        }

        public boolean operator(Entry e) {
            return this.d.ge(e.startDate) && this.d.le(e.endDate);
        }
    }
}

