/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.FloatingRateCoupon;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.indexes.IndexManager;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class IborCoupon
extends FloatingRateCoupon {
    private static final String NULL_TERM_STRUCTURE = "null term structure set to par coupon";

    public IborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, 1.0);
    }

    public IborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, 0.0);
    }

    public IborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, new Date(), new Date());
    }

    public IborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread, Date refPeriodStart, Date refPeriodEnd) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, refPeriodStart, refPeriodEnd, new DayCounter());
    }

    public IborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread, Date refPeriodStart, Date refPeriodEnd, DayCounter dayCounter) {
        this(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, refPeriodStart, refPeriodEnd, dayCounter, false);
    }

    public IborCoupon(Date paymentDate, double nominal, Date startDate, Date endDate, int fixingDays, IborIndex index, double gearing, double spread, Date refPeriodStart, Date refPeriodEnd, DayCounter dayCounter, boolean isInArrears) {
        super(paymentDate, nominal, startDate, endDate, fixingDays, index, gearing, spread, refPeriodStart, refPeriodEnd, dayCounter, isInArrears);
    }

    @Override
    public double indexFixing() {
        Settings settings = new Settings();
        if (settings.isUseIndexedCoupon()) {
            return this.index_.fixing(this.fixingDate());
        }
        if (this.isInArrears()) {
            return this.index_.fixing(this.fixingDate());
        }
        Handle<YieldTermStructure> termStructure = this.index_.termStructure();
        QL.require(termStructure != null, NULL_TERM_STRUCTURE);
        Date today = settings.evaluationDate();
        Date fixing_date = this.fixingDate();
        IndexManager indexManager = IndexManager.getInstance();
        if (fixing_date.lt(today)) {
            double pastFixing = (Double)indexManager.getHistory(this.index_.name()).get(fixing_date);
            QL.require(!Double.isNaN(pastFixing), "Missing fixing");
            return pastFixing;
        }
        if (fixing_date.equals(today)) {
            try {
                double pastFixing = (Double)indexManager.getHistory(this.index_.name()).get(fixing_date);
                if (!Double.isNaN(pastFixing)) {
                    return pastFixing;
                }
            }
            catch (Exception pastFixing) {
                // empty catch block
            }
        }
        Date fixingValueDate = this.index_.fixingCalendar().advance(fixing_date, this.index_.fixingDays(), TimeUnit.Days);
        double startDiscount = termStructure.currentLink().discount(fixingValueDate);
        Date nextFixingDate = this.index_.fixingCalendar().advance(this.accrualEndDate_, -this.fixingDays(), TimeUnit.Days);
        Date nextFixingValueDate = this.index_.fixingCalendar().advance(nextFixingDate, this.index_.fixingDays(), TimeUnit.Days);
        double endDiscount = termStructure.currentLink().discount(nextFixingValueDate);
        double spanningTime = this.index_.dayCounter().yearFraction(fixingValueDate, nextFixingValueDate);
        return (startDiscount / endDiscount - 1.0) / spanningTime;
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

