/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib;

import java.util.Map;
import java.util.TreeMap;
import org.jquantlib.time.Date;

public class Settings {
    private static final String NEGATIVE_RATES = "NEGATIVE_RATES";
    private static final String EXTRA_SAFETY_CHECKS = "EXTRA_SAFETY_CHECKS";
    private static final String TODAYS_PAYMENTS = "TODAYS_PAYMENTS";
    private static final String USE_INDEXED_COUPON = "USE_INDEXED_COUPON";
    private static final String ENFORCES_TODAYS_HISTORIC_FIXINGS = "ENFORCES_TODAYS_HISTORIC_FIXINGS";
    private static final String REFINE_TO_FULL_MACHINE_PRECISION_USING_HALLEYS_METHOD = "REFINE_TO_FULL_MACHINE_PRECISION_USING_HALLEYS_METHOD";
    private static final String EVALUATION_DATE = "EVALUATION_DATE";
    private static final ThreadAttributes attrs = new ThreadAttributes();

    public boolean isNegativeRates() {
        Object var = ((Map)attrs.get()).get(NEGATIVE_RATES);
        return var == null ? false : (Boolean)var;
    }

    public boolean isExtraSafetyChecks() {
        Object var = ((Map)attrs.get()).get(EXTRA_SAFETY_CHECKS);
        return var == null ? false : (Boolean)var;
    }

    public boolean isTodaysPayments() {
        Object var = ((Map)attrs.get()).get(TODAYS_PAYMENTS);
        return var == null ? false : (Boolean)var;
    }

    public boolean isUseIndexedCoupon() {
        Object var = ((Map)attrs.get()).get(USE_INDEXED_COUPON);
        return var == null ? false : (Boolean)var;
    }

    public boolean isEnforcesTodaysHistoricFixings() {
        Object var = ((Map)attrs.get()).get(ENFORCES_TODAYS_HISTORIC_FIXINGS);
        return var == null ? false : (Boolean)var;
    }

    public boolean isRefineHighPrecisionUsingHalleysMethod() {
        Object var = ((Map)attrs.get()).get(REFINE_TO_FULL_MACHINE_PRECISION_USING_HALLEYS_METHOD);
        return var == null ? false : (Boolean)var;
    }

    public void setNegativeRates(boolean negativeRates) {
        ((Map)attrs.get()).put(NEGATIVE_RATES, negativeRates);
    }

    public void setExtraSafetyChecks(boolean extraSafetyChecks) {
        ((Map)attrs.get()).put(EXTRA_SAFETY_CHECKS, extraSafetyChecks);
    }

    public void setTodaysPayments(boolean todaysPayments) {
        ((Map)attrs.get()).put(TODAYS_PAYMENTS, todaysPayments);
    }

    public void setUseIndexedCoupon(boolean todaysPayments) {
        ((Map)attrs.get()).put(USE_INDEXED_COUPON, todaysPayments);
    }

    public void setEnforcesTodaysHistoricFixings(boolean enforceTodaysHistoricFixings) {
        ((Map)attrs.get()).put(ENFORCES_TODAYS_HISTORIC_FIXINGS, enforceTodaysHistoricFixings);
    }

    public void setRefineHighPrecisionUsingHalleysMethod(boolean refineToFullMachinePrecisionUsingHalleysMethod) {
        ((Map)attrs.get()).put(REFINE_TO_FULL_MACHINE_PRECISION_USING_HALLEYS_METHOD, refineToFullMachinePrecisionUsingHalleysMethod);
    }

    public Date evaluationDate() {
        return ((DateProxy)((Map)Settings.attrs.get()).get(EVALUATION_DATE)).value();
    }

    public Date setEvaluationDate(Date evaluationDate) {
        DateProxy proxy = (DateProxy)((Map)attrs.get()).get(EVALUATION_DATE);
        proxy.assign(evaluationDate);
        return proxy;
    }

    private static class DateProxy
    extends Date {
        private DateProxy() {
        }

        private DateProxy value() {
            if (this.isNull()) {
                super.assign(this.todaysSerialNumber());
            }
            return this;
        }

        private Date assign(Date date) {
            super.assign(date.serialNumber());
            super.notifyObservers();
            return this;
        }
    }

    private static class ThreadAttributes
    extends ThreadLocal<Map<String, Object>> {
        private ThreadAttributes() {
        }

        @Override
        public Map<String, Object> initialValue() {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            map.put(Settings.ENFORCES_TODAYS_HISTORIC_FIXINGS, false);
            map.put(Settings.NEGATIVE_RATES, false);
            map.put(Settings.EXTRA_SAFETY_CHECKS, true);
            map.put(Settings.TODAYS_PAYMENTS, true);
            map.put(Settings.USE_INDEXED_COUPON, false);
            map.put(Settings.REFINE_TO_FULL_MACHINE_PRECISION_USING_HALLEYS_METHOD, false);
            map.put(Settings.EVALUATION_DATE, new DateProxy());
            return map;
        }
    }
}

