/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.DarkCal;
import com.mhuss.AstroLib.DarkCalInput;
import com.mhuss.Util.FileU;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class DarkCalProp {
    static final String CFG_FILENAME = "DarkCal.cfg";

    static boolean load(DarkCalInput dci, DarkCal dc) {
        String p;
        String etcCfgFile = "C:\\etc\\DarkCal.cfg";
        String homeCfgFile = "~/DarkCal.cfg";
        String usedCF = null;
        if (FileU.exists(CFG_FILENAME)) {
            usedCF = CFG_FILENAME;
        } else if (FileU.exists(etcCfgFile)) {
            usedCF = etcCfgFile;
        } else if (FileU.exists(homeCfgFile)) {
            usedCF = homeCfgFile;
        } else {
            System.err.println("\nWarning: unable to find DarkCal.cfg:\n\n- I'll try to create a 'template' file for you in the current directory.\n- Edit this file to reflect your location.\n ");
            DarkCalProp.createExampleCfg();
            return false;
        }
        File f = new File(usedCF);
        Properties cf = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (IOException ioe) {
            System.err.println("Unable to open input file " + usedCF + ": " + ioe);
            return false;
        }
        catch (Exception e) {
            System.err.println("Unexpected exception opening input file " + usedCF + ": " + e);
            return false;
        }
        if (null != fis) {
            try {
                cf.load(fis);
                ((InputStream)fis).close();
                System.err.println("Using " + usedCF);
            }
            catch (IOException ioe) {
                System.err.println("Unable to load system properties: " + ioe);
                return false;
            }
        }
        if (null != (p = cf.getProperty("longitude"))) {
            dci.lon = Double.parseDouble(p);
        }
        if (null != (p = cf.getProperty("latitude"))) {
            dci.lat = Double.parseDouble(p);
        }
        if (null != (p = cf.getProperty("timeZone"))) {
            dci.tz = Integer.parseInt(p);
        }
        if (null != (p = cf.getProperty("htmlOutput"))) {
            dc.g_html = Boolean.valueOf(p);
        }
        if (null != (p = cf.getProperty("ignoreDST"))) {
            dc.g_ignoreDst = Boolean.valueOf(p);
        }
        if (null != (p = cf.getProperty("tabDelimited"))) {
            dc.g_tabDelimited = Boolean.valueOf(p);
        }
        if (null != (p = cf.getProperty("useUTC")) && Boolean.valueOf(p).booleanValue()) {
            dci.tz = 0;
            dc.g_ignoreDst = true;
        }
        return true;
    }

    private static void createExampleCfg() {
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(CFG_FILENAME));
            if (null != pw) {
                pw.println("# DarkCal.cfg\n# Note: East and North are positive\n# e.g., Philadelphia, PA, US is latitude -75.16, longitude 39.95,\n#       and timeZone -5\nlongitude=0.0\nlatitude=0.0\ntimeZone=0\n\n# Set this to true to ignore Daylight time:\nignoreDST=false\n\n# Set this to true to use UTC (this overrides timeZone & DST)\nuseUTC=false\n\n# Set this to true to output to an HTML file:\nhtmlOutput=false\n\n# Set this to true to produce a text file with tab-delimited fields:\n# (Note: html & tabs are mutually exclusive!)\ntabDelimited=false\n");
                pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

