/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.utilities;

import com.yahoo.egads.data.TimeSeries;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TimeSeries> createTimeSeries(String csv_file, Properties config) {
        String fileToParse = csv_file;
        BufferedReader fileReader = null;
        ArrayList<TimeSeries> output = new ArrayList<TimeSeries>();
        String delimiter = ",";
        Long interval = null;
        Long prev = null;
        Integer aggr = 1;
        boolean fillMissing = false;
        if (config.getProperty("FILL_MISSING") != null && config.getProperty("FILL_MISSING").equals("1")) {
            fillMissing = true;
        }
        if (config.getProperty("AGGREGATION") != null) {
            aggr = new Integer(config.getProperty("AGGREGATION"));
        }
        try {
            String line = "";
            fileReader = new BufferedReader(new FileReader(fileToParse));
            boolean firstLine = true;
            while ((line = fileReader.readLine()) != null) {
                String[] tokens = line.split(",");
                Long curTimestamp = null;
                if (firstLine && !FileUtils.isNumeric(tokens[0]) && !tokens[0].equals("timestamp")) continue;
                if (!firstLine && tokens.length > 1) {
                    curTimestamp = new Double(tokens[0]).longValue();
                }
                for (int i = 1; i < tokens.length; ++i) {
                    if (firstLine) {
                        TimeSeries ts = new TimeSeries();
                        ts.meta.fileName = csv_file;
                        output.add(ts);
                        if (!FileUtils.isNumeric(tokens[i])) {
                            ts.meta.name = tokens[i];
                            continue;
                        }
                        ts.meta.name = "metric_" + i;
                        output.get(i - 1).append(new Double(tokens[0]).longValue(), new Float(tokens[i]).floatValue());
                        continue;
                    }
                    if (interval != null && prev != null && interval > 0L && fillMissing && curTimestamp - prev != interval) {
                        int missingValues = (int)((curTimestamp - prev) / interval);
                        Long curTimestampToFill = prev + interval;
                        for (int j = missingValues - 1; j > 0; --j) {
                            Float valToFill = new Float(tokens[i]);
                            if (output.get(i - 1).size() >= missingValues) {
                                valToFill = Float.valueOf(((TimeSeries.Entry)output.get((int)(i - 1)).data.get((int)(output.get((int)(i - 1)).size() - missingValues))).value);
                            }
                            output.get(i - 1).append(curTimestampToFill, valToFill.floatValue());
                            curTimestampToFill = curTimestampToFill + interval;
                        }
                    }
                    if (interval == null && prev != null) {
                        interval = curTimestamp - new Long(prev);
                    }
                    output.get(i - 1).append(curTimestamp, new Float(tokens[i]).floatValue());
                }
                if (!firstLine) {
                    prev = curTimestamp;
                }
                firstLine = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (aggr > 1) {
            for (TimeSeries t : output) {
                t.data = t.aggregate(aggr);
                t.meta.name = t.meta.name + "_aggr_" + aggr;
            }
        }
        return output;
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int[] splitInts(String str) throws IllegalArgumentException {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int n = tokenizer.countTokens();
        int[] list = new int[n];
        for (int i = 0; i < n; ++i) {
            String token = tokenizer.nextToken();
            list[i] = Integer.parseInt(token);
        }
        return list;
    }

    public static void initProperties(String config, Properties p) {
        String delims1 = ";";
        String delims2 = ":";
        StringTokenizer st1 = new StringTokenizer(config, delims1);
        while (st1.hasMoreElements()) {
            String[] st2 = st1.nextToken().split(delims2);
            p.setProperty(st2[0], st2[1]);
        }
    }
}

